package org.jboss.soa.esb.message.format;

import java.net.URI;

import org.jboss.internal.soa.esb.message.format.MessageFactoryImpl;
import org.jboss.soa.esb.message.Message;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * You get a message of a specific type when you need it. Obviously that type may not be
 * suitable for the service (hopefully you've got that contractual information a priori, but
 * maybe not) and in which case some translation/transformation may be necessary.
 * 
 * Different ways of viewing and manipulating the Message Body (payload) are available separately
 * via the Payload class. In future releases it will be possible to define the payload type at
 * creation time.
 * 
 * @author Mark Little
 *
 */

public abstract class MessageFactory
{
	/**
	 * @return the default implementation.
	 */
	
	public abstract Message getMessage ();
	
	/**
	 * @param type the unique identifier representing the type of this message.
	 * @return the message, or <code>null</code> if no suitable plugin is available.
	 */
	
	public abstract Message getMessage (URI type);
	
	/**
	 * @param msg the message to convert.
	 * @param type the type of the message we want to convert to.
	 * @return a translated message, or <code>null</code> if no suitable plugin is available.
	 * @deprecated Not implemented in 4.2.
	 */
	
	public abstract Message getMessage (Message msg, URI type);
	
	/**
	 * Reload the plugins.
	 */
	
	public abstract void reset ();
	
	/**
	 * Given a Message, return the Body component as a specific type for
	 * manipulation, e.g., TextMessage or BytesMessage.
	 * 
	 * @param m the Message
	 * @param bodyType the type of Body to "cast" to.
	 * @return the Body.
	 */
	
	public abstract Object createBodyType (Message m, String bodyType);
	
	// TODO setters/getters for the plugin programmatically too.
	
	public static MessageFactory getInstance ()
	{
		return theFactory;
	}
	
	private static final MessageFactory theFactory = new MessageFactoryImpl();
	
}
