package org.jboss.soa.esb.message.helper.content;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.body.content.MapBody;
import org.jboss.soa.esb.message.body.content.ObjectBody;
import org.jboss.soa.esb.message.body.content.Payload;
import org.jboss.soa.esb.message.body.content.TextBody;
import org.jboss.soa.esb.message.format.MessageFactory;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * You get a message of a specific type when you need it and it
 * is initialized with state.
 * 
 * @author Mark Little
 *
 */

public class ContentManager
{	
	public Message createTextMessage (String initial)
	{
		if (initial == null)
			throw new IllegalArgumentException();
		
		Message msg = MessageFactory.getInstance().getMessage(_type);
		
		try
		{
			TextBody payload = (TextBody) MessageFactory.getInstance().createBodyType(msg, Payload.TEXT_BODY);
			
			payload.setText(initial);
			
			return msg;
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		return null;
	}
	
	public Message createObjectMessage (Serializable initial)
	{
		if (initial == null)
			throw new IllegalArgumentException();
		
		Message msg = MessageFactory.getInstance().getMessage(_type);
		
		try
		{
			ObjectBody payload = (ObjectBody) MessageFactory.getInstance().createBodyType(msg, Payload.OBJECT_BODY);
			
			payload.setObject(initial);
			
			return msg;
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		return null;
	}
	
	public Message createMapMessage (Map<String, Serializable> initial)
	{
		if (initial == null)
			throw new IllegalArgumentException();
		
		Message msg = MessageFactory.getInstance().getMessage(_type);
		
		try
		{
			MapBody payload = (MapBody) MessageFactory.getInstance().createBodyType(msg, Payload.MAP_BODY);
			
			payload.setMap(initial);
			
			return msg;
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		return null;
	}
	
	public Message createBytesMessage (byte[] initial)
	{
		if (initial == null)
			throw new IllegalArgumentException();
		
		Message msg = MessageFactory.getInstance().getMessage(_type);
		
		try
		{
			BytesBody payload = (BytesBody) MessageFactory.getInstance().createBodyType(msg, Payload.BYTES_BODY);
			
			payload.add(BytesBody.BYTES_LOCATION, initial);
			
			return msg;
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		return null;
	}

	protected ContentManager (URI type)
	{
		_type = type;
	}
	
	private URI _type;
	
}
