/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.security.AccessController;
import java.util.Collections;
import java.util.Set;

import javax.security.auth.Subject;

import org.picketlink.identity.federation.core.wstrust.SamlCredential;

/**
 * SamlContext provides a way to retreive a SamlCredential or Set
 * of SamlCredentials from the current {@link Subject}. 
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public final class SamlContext
{
    private SamlContext() {}

    /**
     * Get a list of the Subject SamlCredentials.
     * 
     * @return Set Set of SamlCredentials. This method will return an empty set if no SamlCredentials exist.
     */
    public static Set<SamlCredential> getSamlCredentials()
    {
        final Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null)
            return Collections.emptySet();
        
        return subject.<SamlCredential>getPublicCredentials(SamlCredential.class);
    }
    
    /**
     * Gets the first SamlCredential belonging to the current Subject.
     * 
     * @return SamlCredential The first SamlCredential or null if there are none.
     */
    public static SamlCredential getFirstSamlCredential()
    {
        final Set<SamlCredential> samlCredentials = getSamlCredentials();
        if (samlCredentials.isEmpty())
        {
            return null;
        }
        
        return samlCredentials.iterator().next();
    }

}
