/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.internal.soa.esb.couriers.tests;

import java.io.File;
import java.net.URI;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.junit.Test;

/**
 * Tests for internal FtpFileHandler class
 * 
 * @since Version 4.0
 * 
 */
public class CourierUtilUnitTest extends BaseTest
{
	private Logger log = Logger.getLogger( CourierUtilUnitTest.class );
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(CourierUtilUnitTest.class);
	}
	
	@Test
	public void testMessageToFile () throws Exception
	{
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		
        msg1.getBody().add("bar");
		msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
		msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		
		log.debug("Saving: "+msg1.getHeader().getCall());
		
		File f = CourierUtil.messageToLocalFile(new File("."), msg1);
		
		f.delete();
	}
	
	@Test
	public void testMessageFromFile () throws Exception
	{
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		
		msg1.getBody().add("bar");
		msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
		msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		
		Assert.assertEquals(msg1.getHeader().getCall().getTo().getAddr().toString(), "PortReference < http://foo.bar >");
		
		File theFile = new File(".");
		File tmpFile = CourierUtil.messageToLocalFile(theFile, msg1);
		
		Message msg2 = CourierUtil.messageFromLocalFile(tmpFile);
		
		log.debug("Restored: "+msg2.getHeader().getCall());
		
		tmpFile.delete();
		
		Assert.assertNotNull(msg2);
		Assert.assertEquals(msg2.getBody().get(), "bar");
		Assert.assertEquals(msg2.getHeader().getCall().getMessageID().toString(), "urn:1234");
		Assert.assertEquals(msg2.getHeader().getCall().getTo().getAddr().toString(), "PortReference < http://foo.bar >");
	}
	
}
