package org.jboss.internal.soa.esb.webservice;

import static org.mockito.Matchers.anyInt;
import static org.mockito.Matchers.anyObject;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.mock;
import static junit.framework.Assert.assertNotNull;

import java.net.URI;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.message.Fault;
import org.jboss.soa.esb.message.Message;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;


/**
 * Unit test for {@link BaseWebService}
 * 
 * @author Daniel Bevenius
 */
public class BaseWebServiceUnitTest
{
    private String currentSOAPMessageFactoryImpl;
    
    @Before
    public void setAS610SOAPMessageFactory() {
        currentSOAPMessageFactoryImpl = System.getProperty("javax.xml.soap.MessageFactory", "");
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl");
    }
    
    @After
    public void resetSOAPMessageFactory() {
        System.setProperty("javax.xml.soap.MessageFactory", currentSOAPMessageFactoryImpl);
    }
    
    @Test
    public void createFault_using_default_soap_message_factory() throws Exception {
        final SOAPMessage result = invokeCausingFault();
        assertNotNull("No detail was added as added since a DOMException: WRONG_DOCUMENT_ERR was thrown but only logged as WARN", 
                    result.getSOAPBody().getFault().getDetail().getFirstChild());
    }
    
    private SOAPMessage invokeCausingFault() throws Exception {
        // Create Message with a fault
        final Message message = org.jboss.soa.esb.message.format.MessageFactory.getInstance().getMessage();
        message.getBody().add(Fault.DETAIL_CODE_CONTENT, new QName("someNs", "fault:one"));
        message.getBody().add(Fault.DETAIL_DESCRIPTION_CONTENT, "Something went wrong");
        message.getBody().add(Fault.DETAIL_DETAIL_CONTENT, "<detail>Very wrong</detail>");
        final FaultMessageException faultException = new FaultMessageException("Some error message", new URI("http://dummy.com"), message);
        
        // Create mock service invoker
        final ServiceInvoker serviceInvoker = mock(ServiceInvoker.class);
        doThrow(faultException).when(serviceInvoker).deliverSync((Message)anyObject(), anyInt());
        
        final RequestResponseBaseWebService webService = new RequestResponseBaseWebService("deployment", serviceInvoker, null, null, "action", null);
        final SOAPMessage soapMessage = createSOAPMessageWithPayload();
        return webService.invoke(soapMessage);
    }
    
    private SOAPMessage createSOAPMessageWithPayload() throws Exception
    {
        final SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
        final SOAPBody soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
        final SOAPBodyElement bodyElement = soapBody.addBodyElement(new QName("content"));
        bodyElement.addTextNode("dummyPayload");
        return soapMessage;
    }
    
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( BaseWebServiceUnitTest.class );
	}

}
