/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.cbr.regex;

import junit.framework.TestCase;
import org.jboss.soa.esb.testutils.ESBConfigUtil;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.actions.cbr.RoutingRule;
import org.jboss.soa.esb.actions.cbr.RegexRouter;
import org.jboss.soa.esb.actions.cbr.XPathRouter;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.File;
import java.util.Map;
import java.util.List;
import java.util.Arrays;
import java.util.regex.Pattern;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class RegexRouterUnitTest extends TestCase {

    public void test_rulefile_load_classpath() throws IOException, SAXException, ConfigurationException, MessageRouterException {
        test("1");
    }

    public void test_rulefile_load_filesys() throws IOException, SAXException, ConfigurationException, MessageRouterException {
        String cwd = new File(".").getAbsolutePath().replace("\\", "/");
        if(!cwd.endsWith("product/.")) {
            throw new IllegalStateException("Invalid working directory for test.  Must be the 'product/rosetta/tests' dir.  Current working directory is '" + cwd + "'.");
        }

        test("2");
    }

    public void test_inlineRules() throws IOException, SAXException, ConfigurationException, MessageRouterException {
        test("3");
    }

    private void test(String configName) throws MessageRouterException, IOException, SAXException, ConfigurationException {
        ESBConfigUtil esbConfig = new ESBConfigUtil(getClass().getResourceAsStream("config.xml"));
        ConfigTree configTree = esbConfig.getActionConfig("null-listener", configName);
        RegexRouter router = new RegexRouter();

        router.setConfigTree(configTree);

        Map<String, RoutingRule> map = router.getRoutingMap();
        assertEquals(3, map.size());
        assertNotNull(map.get("scat-red"));
        assertNotNull(map.get("scat-green"));
        assertNotNull(map.get("scat-blue"));
    }

    public static final String GREEN_MESSAGE = "#############333#############";

    public void test_routing_String() throws IOException, SAXException, ConfigurationException, MessageRouterException {
        Message message = MessageFactory.getInstance().getMessage();

        message.getBody().add(GREEN_MESSAGE);
        test_routing(message, null);
    }

    public void test_routing_ObjectList() throws IOException, SAXException, ConfigurationException, MessageRouterException {
        Message message = MessageFactory.getInstance().getMessage();

        message.getBody().add("x", "<x/>");
        message.getBody().add("y", GREEN_MESSAGE);
        test_routing(message, Arrays.asList(GREEN_MESSAGE));
    }

    public void test_routing(Message message, List objectLists) throws IOException, SAXException, ConfigurationException, MessageRouterException {
        ESBConfigUtil esbConfig = new ESBConfigUtil(getClass().getResourceAsStream("config.xml"));
        ConfigTree configTree = esbConfig.getActionConfig("null-listener", "3");
        RegexRouter router = new RegexRouter();

        router.setConfigTree(configTree);

        List<String> destinations = router.route(null, false, message, objectLists);
        assertEquals("[scat-green]", destinations.toString());
    }
}