/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.validation;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.UnsupportedEncodingException;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Test;


/**
 * Unit test for {@link SchemaValidationAction}.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class SchemaValidationActionUnitTest
{
    @Test
    public void process() throws ActionProcessingException, ConfigurationException, UnsupportedEncodingException
    {
        process("test.xml", "test.xsd");
    }

    @Test
    public void processImport() throws ActionProcessingException, ConfigurationException, UnsupportedEncodingException
    {
        process("importtest.xml", "importtest.xsd");
    }

    @Test
    public void processInvalidXml() throws ActionProcessingException, ConfigurationException, UnsupportedEncodingException
    {
        try
        {
            process("test-invalid.xml", "test.xsd");
            fail("processing invalid xml should fail validation");
        }
        catch (final Exception e)
        {
            assertTrue(e instanceof ValidationException);
        }
    }

    private void process(final String xmlFileName, final String xsdFileName) throws ConfigurationException, ActionProcessingException
    {
        final ConfigTree config = createConfiguration(xsdFileName);
        final SchemaValidationAction action = new SchemaValidationAction(config);
        final Message message = MessageFactory.getInstance().getMessage();
        final byte[] xml = StreamUtils.readStream(getClass().getResourceAsStream(xmlFileName));
        message.getBody().add(xml);

        action.process(message);
    }

    private ConfigTree createConfiguration(final String xsdPath)
    {
        final ConfigTree config = new ConfigTree("junittest");
        config.setAttribute("schema", xsdPath);
        return config;
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SchemaValidationActionUnitTest.class);
    }
}
