/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.config;

import static org.junit.Assert.assertTrue;

import java.io.File;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.testutils.TestEnvironmentUtil;
import org.junit.Test;

/**
 * Testing configuration controller.
 * 
 * @author kurt.stam@redhat.com
 *
 */
public class ConfigurationControlerUnitTest 
{
	private static Logger logger = Logger.getLogger(ConfigurationControlerUnitTest.class);
	
	@Test
	public void readAndGenerateConfig() throws Exception
	{
		executeTest("rosetta/tests/src/org/jboss/soa/esb/listeners/config/jbossesb_config_01.xml",
			"etc/schemas/xml/jbossesb-1.0.1.xsd");
	}
	
    
    @Test
    public void readAndGenerateConfig110() throws Exception
    {
        executeTest("rosetta/tests/src/org/jboss/soa/esb/listeners/config/jbossesb_config_01.110.xml",
            "etc/schemas/xml/jbossesb-1.1.0.xsd");
    }
    
    @Test
    public void readAndGenerateConfig120() throws Exception
    {
        executeTest("rosetta/tests/src/org/jboss/soa/esb/listeners/config/jbossesb_config_01.120.xml",
            "etc/schemas/xml/jbossesb-1.2.0.xsd");
    }
    
    @Test
    public void readAndGenerateConfig130() throws Exception
    {
        executeTest("rosetta/tests/src/org/jboss/soa/esb/listeners/config/jbossesb_config_01.130.xml",
            "etc/schemas/xml/jbossesb-1.3.0.xsd");
    }
    
    @Test
    public void readAndGenerateConfig131() throws Exception
    {
        executeTest("rosetta/tests/src/org/jboss/soa/esb/listeners/config/jbossesb_config_01.131.xml",
            "etc/schemas/xml/jbossesb-1.3.1.xsd");
    }

    private void executeTest(final String config, final String schema)
        throws Exception
    {
        String configFileName = TestEnvironmentUtil.getUserDir("product") + config;
        //Make sure this file exists
        File configFile = new File(configFileName);
        assertTrue("File '" + configFile + "' doesn't exist.", configFile.exists());
        //Remove the listener and gateway configuration files if they exist
        File currentDir = configFile.getParentFile();
        if (null==currentDir)
            currentDir=new File("");
        File listenerFile = new File(currentDir + File.separator + "jbossesb-listener.xml");
        if (listenerFile.exists()) {
            listenerFile.delete();
        }
        File gatewayFile = new File(currentDir + File.separator + "jbossesb-gateway.xml");
        if (gatewayFile.exists()) {
            gatewayFile.delete();
        }
        String validationFileName = TestEnvironmentUtil.getUserDir("product") + schema;
//      Make sure this file exists
        File validationFile = new File(validationFileName);
        assertTrue("File '" + validationFile + "' doesn't exist.", validationFile.exists());

        ConfigurationController controller = new ConfigurationController(configFileName, validationFileName);
        for (int i=0; i<currentDir.listFiles().length;i++){
            logger.info(currentDir.listFiles()[i].getName());
        }

        assertTrue("file=" + listenerFile.getAbsolutePath() + " does not exist, while it should have.  Actually exists in " + controller.getListenerConfigFile(), listenerFile.exists());
        listenerFile.delete();

        assertTrue("file=" + gatewayFile.getAbsolutePath() + " does not exist, while it should have.  Actually exists in " + controller.getGatewayConfigFile(), gatewayFile.exists());
        gatewayFile.delete();
    }
    
	public static junit.framework.Test suite() {
		return new JUnit4TestAdapter(ConfigurationControlerUnitTest.class);
	}

}
