/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.jboss.soa.esb.ConfigurationException;

import junit.framework.TestCase;

/**
 * Test for bug http://jira.jboss.com/jira/browse/JBESB-1993.
 * 
 * @author <a href="mailto:Kevin.Conner@jboss.com">Kevin Conner</a>
 */
public class JBESB_1993_UnitTest extends TestCase
{
    public void testActionNames()
        throws Exception
    {
        runTest("JBESB_1993_action.xml", "Tried to register a duplicate action name.") ;
    }
    
    public void testServiceNames()
        throws Exception
    {
        runTest("JBESB_1993_service.xml", "Service names must be unique within a category.") ;
    }
    
    private void runTest(final String resource, final String expected)
        throws Exception
    {
        final InputStream resourceIs = getClass().getResourceAsStream(resource) ;
        final ByteArrayOutputStream listenerBAOS = new ByteArrayOutputStream() ;
        final ByteArrayOutputStream gatewayBAOS = new ByteArrayOutputStream() ;
        final Generator generator = new Generator(resourceIs, listenerBAOS, gatewayBAOS) ;
        try
        {
            generator.generate();
        }
        catch (final ConfigurationException ce)
        {
            if (!ce.getMessage().startsWith(expected))
            {
                throw ce ;
            }
        }
    }
}
