/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.net.URL;
import java.util.Set;

import javax.management.ObjectName;

import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.soa.esb.listeners.deployers.mc.util.VfsUtil;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.virtual.VirtualFile;

/**
 * Unit tests for {@link EsbConfigParser}.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class EsbConfigParserUnitTest extends MicrocontainerTest
{
    private URL dir = getClass().getResource("/org/jboss/soa/esb/listeners/deployers/mc/test_esb_archives");
    
    private EsbConfigParser parserDeployer = new EsbConfigParser();
    
    public EsbConfigParserUnitTest(String name)
    {
        super(name);
    }
    
    public void testExplodedEsbArchiveDependencies() throws Throwable
    {
        EsbMetaData esbMetaData = TestUtil.getEsbMetaData(parserDeployer, dir, "exploded-esb-archive.esb");
        assertEquals("exploded-esb-archive.esb", esbMetaData.getArchiveName());
        assertEquals("exploded-esb-archive", esbMetaData.getDeploymentName());
        
        Set<ObjectName> deps = esbMetaData.getDependencies();
        
        assertEquals(4, deps.size());
        assertTrue(deps.contains(new ObjectName("jboss.esb.quickstart.destination:service=Queue,name=quickstart_helloworld_Request_esb")));
        assertTrue(deps.contains(new ObjectName("jboss.esb.quickstart.destination:service=Queue,name=quickstart_helloworld_Request_gw")));
        assertTrue(deps.contains(new ObjectName("jboss.web.deployment:war=/test2")));
        assertTrue(deps.contains(new ObjectName("jboss.esb:deployment=jbossesb.esb")));
    }
    
    public void testGetDependenciesFromDeploymentUnit() throws Exception
    {
        VFSDeploymentUnit unit = TestUtil.getDeploymentUnit(dir, "exploded-esb-archive.esb");
        Set<ObjectName> deps = parserDeployer.getDependenciesFromDeploymentXml(unit);
        
        assertFalse(deps.isEmpty());
        assertEquals(3, deps.size());
        assertTrue(deps.contains(new ObjectName("jboss.esb.quickstart.destination:service=Queue,name=quickstart_helloworld_Request_esb")));
        assertTrue(deps.contains(new ObjectName("jboss.web.deployment:war=/test2")));
        assertTrue(deps.contains(new ObjectName("jboss.esb.quickstart.destination:service=Queue,name=quickstart_helloworld_Request_gw")));
    }
    
    public void testGetDependenciesFromDeploymentUnitNoDeps() throws Exception
    {
        VirtualFile vfs = VfsUtil.createInMemoryFs(VfsUtil.createInMemUrl("confParser"));
        VFSDeploymentUnit unit = TestUtil.getDeploymentUnit(vfs);
        Set<ObjectName> deps = parserDeployer.getDependenciesFromDeploymentXml(unit);
        
        assertTrue(deps.isEmpty());
    }
    
    public void testDeploymentName() throws Exception
    {
        VirtualFile vfs = VfsUtil.createInMemoryFs(VfsUtil.createInMemUrl("confParser"));
        VFSDeploymentUnit unit = TestUtil.getDeploymentUnit(vfs);
        
        assertEquals("", parserDeployer.getDeploymentName(unit));
    }
    
    public void testGetDeploymentName() throws Exception
    {
        VFSDeploymentUnit unit = TestUtil.getDeploymentUnit(dir, "exploded-esb-archive.esb");
        
        assertEquals("exploded-esb-archive", parserDeployer.getDeploymentName(unit));
    }
    
}
