/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.message.format.serialized.MessageImpl;
import org.jboss.soa.esb.message.Attachment;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.util.Util;

/**
 * Unit tests for the Class class.
 * 
 * @author Mark Little
 */

public class AttachmentUnitTest extends TestCase
{
	private Logger log = Logger.getLogger( AttachmentUnitTest.class );
	
	public void testSerializeAttachment()
	    throws Exception
	{
		Message msg = MessageFactory.getInstance().getMessage(
				MessageType.JAVA_SERIALIZED);

		assertEquals((msg != null), true);

		Attachment at = msg.getAttachment();

		assertEquals((msg != null), true);

		at.addItem(new ExampleObject(0)); // un-named
		at.addItemAt(0, new ExampleObject(0)); // un-named;

		try
		{
			at.addItem(new Object());

			fail();
		}
		catch (IllegalArgumentException ex)
		{
		}

		assertEquals(at.getUnnamedCount(), 2);

		assertEquals(at.get("foo"), null);

		at.put("foobar", new ExampleObject(1));

		assertEquals(at.getNamedCount(), 1);

		at.addItem(new ExampleObject(1));
		at.addItem(new ExampleObject(2));

		assertEquals((at.getNames() != null), true);

		assertEquals((at.removeItemAt(0) != null), true);

		at.replaceItemAt(0, new ExampleObject(2));

		int count = at.getUnnamedCount();

                ByteArrayOutputStream s = new ByteArrayOutputStream();
                ObjectOutputStream o = new ObjectOutputStream(s);

                o.writeObject(msg);
                o.close();

                ByteArrayInputStream is = new ByteArrayInputStream(s.toByteArray());
                ObjectInputStream io = new ObjectInputStream(is);

                MessageImpl nImpl = (MessageImpl) io.readObject();

                assertEquals(nImpl.getAttachment().getUnnamedCount(), count);
	}

	public void testXMLAttachment()
	    throws Exception
	{
		Message msg = MessageFactory.getInstance().getMessage(
				MessageType.JBOSS_XML);

		assertEquals((msg != null), true);

		Attachment at = msg.getAttachment();

		assertEquals((msg != null), true);

		at.addItem(new ExampleObject(0)); // un-named
		at.addItemAt(0, new ExampleObject(0)); // un-named;

		try
		{
			at.addItem(new Object());

			fail();
		}
		catch (IllegalArgumentException ex)
		{
		}

		assertEquals(at.getUnnamedCount(), 2);

		assertEquals(at.get("foo"), null);

		at.put("foobar", new ExampleObject(1));

		assertEquals(at.getNamedCount(), 1);

		at.addItem(new ExampleObject(1));
		at.addItem(new ExampleObject(2));

		assertEquals((at.getNames() != null), true);

		assertEquals((at.removeItemAt(0) != null), true);

		at.replaceItemAt(0, new ExampleObject(2));

		int count = at.getUnnamedCount();

                final String documentAsString = (String)Util.serialize(msg) ;
                log.debug("Message looks like: " + documentAsString);
                final Message nImpl = Util.deserialize(documentAsString) ;
                
                assertEquals(nImpl.getAttachment().getUnnamedCount(), count);
	}

}
