/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.net.URL;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * Unit test for {@link PasswordUtil}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class PasswordUtilUnitTest
{
    private String jbossEsbProperties;
    
    @Test
    public void getPassword() throws IOException
    {
        final  URL file = getClass().getResource("esb.password");
        final PasswordUtil passwordUtil = new PasswordUtil(file.getFile());
        
        final  char[] password = passwordUtil.getPassword();
        assertNotNull(password);
        assertEquals("JBossESB", new String(password));
    }
    
    @Test (expected = IllegalArgumentException.class )
    public void shouldThrowIfSecurityDomainIsNull() throws Exception
    {
        new PasswordUtil(null);
    }
    
    @Test
    public void isPasswordFile()
    {
        final  URL file = getClass().getResource("esb.password");
        assertTrue(PasswordUtil.isPasswordFile(file.getFile()));
        assertFalse(PasswordUtil.isPasswordFile("somepass"));
        assertFalse(PasswordUtil.isPasswordFile("/webservice_proxy_security_pass"));
        assertFalse(PasswordUtil.isPasswordFile(null));
        assertFalse(PasswordUtil.isPasswordFile(""));
    }
    
	@Before
    public void setup() throws ConfigurationException
    {
        jbossEsbProperties = System.getProperty(Environment.PROPERTIES_FILE);
        URL resource = ClassUtil.getResource("security-properties.xml", getClass());
        System.setProperty(Environment.PROPERTIES_FILE, "abs://" + resource.getFile());
    }

    @After
    public void tearDown()
    {
        if ( jbossEsbProperties != null )
            System.setProperty(Environment.PROPERTIES_FILE, jbossEsbProperties);
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(PasswordUtilUnitTest.class);
    }

}
