/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.services.jbpm.cmd;

import junit.framework.TestCase;
import org.jboss.soa.esb.testutils.ESBConfigUtil;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.services.jbpm.Mapping;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.xml.sax.SAXException;

import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ConfigUtilTest extends TestCase {

    public void test_esbToJBPM_Mapping() throws IOException, SAXException, ConfigurationException {
        ESBConfigUtil configUtil = new ESBConfigUtil(getClass().getResourceAsStream("mappingconfig-01.xml"));
        ConfigTree actionConfig = configUtil.getActionConfig("InVM-0", "action1");

        List<Mapping> mappingConfig = ConfigUtil.getMappingConfig(actionConfig);
        assertEquals("[Mapping[ esb=eVar1, bpm=counter, isProcessScope=null, defaultValue=null ], Mapping[ esb=BODY_CONTENT, bpm=theBody, isProcessScope=null, defaultValue=null ]]", mappingConfig.toString());
    }
}
