/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm5.model;

/**
 * Constants used in the BPM5Processor.
 *  
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.11
 */
public class ProcessConstants {
	/* EPR reply/fault */
	public static final String EPR_REPLY = "reply" ;
    public static final String EPR_FAULT = "fault" ;
    public static final String REPLY_TO = "jbpmReplyTo";
    public static final String FAULT_TO = "jbpmFaultTo";

	
	/* Process Types */
	public static final String START_PROCESS_TYPE = "startProcess";
	public static final String SIGNAL_EVENT_TYPE = "signalEvent";
    public static final String ABORT_PROCESS_INSTANCE_TYPE = "abortProcessInstance";

	/* Events */
    public static final String PROCESS_EVENT_TYPE = "processEventType";
    public static final String PROCESS_EVENT = "processEvent";
    
    /* Handler Class properties */
    public static final String PROCESS_HANDLER_CLASS = "processHandlerClass";
    public static final String PROCESS_HANDLER_HOST = "processHandlerHost";
    public static final String PROCESS_HANDLER_PORT = "processHandlerPort";
        
    /* Tags */
    public static final String PROCESS_DEFINITION_NAME = "process-definition-name";
    public static final String PROCESS_ID = "process-id";
    public static final String PROCESS_COMMAND = "command";
    public static final String PROCESS_ACTION = "process-action";
    public static final String ESB_TO_BPM_PARAMS = "esbToBpmParams";
    public static final String ENTITY_FACTORY_NAME = "entityFactoryName";

    /* Message context properties */
    public static final String SESSION_ID = "jbpm5-session-id";
    public static final String PROCESS_INSTANCE_ID = "jbpm5-processinstance-id";
	public static final String WORK_ITEM_ID					= "jbpmWorkItemId";

}
