/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.rules.util;

import java.io.File;
import java.io.IOException;

import junit.framework.JUnit4TestAdapter;

import org.drools.compiler.DroolsParserException;
import org.jboss.soa.esb.ConfigurationException;
import org.junit.Test;

/**
 * Unit test for {@link PackageFileGenerator}.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class PackageFileGeneratorUnitTest
{
    @Test (expected = IllegalArgumentException.class)
    public void shouldThrowIfMissingArguments() throws DroolsParserException, ConfigurationException, IOException
    {
        PackageFileGenerator.main(new String[]{});
    }
    
    @Test 
    public void main() throws DroolsParserException, ConfigurationException, IOException
    {
        final String drlName = "/RuleBaseHelper.drl";
        final String pkgFile = "ruleBaseHelper.pkg";
        try
        {
            PackageFileGenerator.main(new String[]{drlName, pkgFile});
        }
        finally
        {
            final File createdPkg = new File(pkgFile);
            if (createdPkg.exists());
            {
                createdPkg.delete();
            }
        }
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(PackageFileGeneratorUnitTest.class);
    }
}
