/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters;

import java.io.InputStream;

import javax.xml.transform.stream.StreamSource;

import org.jboss.soa.esb.actions.BeanConfiguredAction;
import org.jboss.soa.esb.message.Message;
import org.milyn.container.plugin.SourceResult;

/**
 * StreamToSourceResult prepares the message object before invoking a Smooks transformation.
 * <p/>
 * Some tranformation need more control over the input and output generated by Smooks. By creating
 * a SourceResult the calling application can control the types of input and output Result object. </br>
 * <p/>
 * This specific action creates a SourceResult with a StreamSource containing an InputStream located 
 * in the default body location. <br>
 * The Result for this SourceResult will be null, as we don't want any processing of the result. This <br>
 * is useful when you have very large files that need to be processed and using a Smooks router to route <br>
 * the results and not process them.
 * 
 * Example configuration:
 * <pre>
 *&lt;action name="createSourceResult" class="org.jboss.soa.esb.actions.converters.StreamToSourceResult"/&gt;
 * </pre>
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>			
 * @since 4.3
 *
 */
public class StreamToSourceResult implements BeanConfiguredAction
{
	public Message process( final Message message )
	{
		Object object = message.getBody().get();
		if ( object instanceof InputStream )
		{
			final SourceResult sourceResult = new SourceResult( new StreamSource ( (InputStream) object ), null );
			message.getBody().add( sourceResult );
		}
		
		return message;
	}

}
