/*
 * JBoss, Home of Professional Open Source Copyright 2012, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.soap.wise;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import it.javalinux.wise.core.client.WSDynamicClient;
import it.javalinux.wise.core.client.WSEndpoint;
import it.javalinux.wise.core.client.WSMethod;
import it.javalinux.wise.core.utils.WiseProperties;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import junit.framework.JUnit4TestAdapter;

import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.internal.soa.esb.soap.wise.WSMethodParameterMappingAspect;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author <a href='mailto:mbojan@jboss.com'>Magesh Kumar B</a>
 */
public class SOAPClientAspectUnitTest
{
    private static final String workingDir = "working";
    private static File workingDirFile;

    @BeforeClass
    public static void setup()
    {
        workingDirFile = new File(workingDir);
        workingDirFile.mkdir();
    }
    
    @AfterClass
    public static void teardown()
    {
        workingDirFile.delete();
    }

    @Test
    public void wrappedService() throws Throwable
    {
        WiseProperties props = WiseProperties.newInstance(workingDir);
        props.setProperty("wise.forceImportObject", "true");
        props.setProperty("wise.targetPackage", "org.jboss.soa.esb.actions.soap.wise");
        props.setProperty("wise.keepGeneratedSources", "true");
        props.setProperty("wise.wsImporter.verbose", "true");

        WSDynamicClient client = new WSDynamicClient(props);
        assertNotNull(client);
        client.init(getClass().getResource("wrappedservice.wsdl").toExternalForm(), "wrappedservice", null, null);
        Map<String, WSEndpoint> endpoints = client.processEndpoints();
        assertNotNull(endpoints);
        Map<String, WSMethod> methods = endpoints.get("PingWSPort").getWSMethods();
        assertNotNull(methods);
        WSMethod method = methods.get("pingComplexObject");
        assertNotNull(method);

        Map<String, Object> args = new HashMap<String, Object>();
        PingComplexObject wrapper = new PingComplexObject();
        ComplexObject complex = new ComplexObject();
        complex.setIntegerField(1);
        complex.setStringField("Testing with AOP");
        Date date = new Date();
        complex.setCalendarField(date);
        wrapper.setComplexObject(complex);
        wrapper.setName("Dexter");
        args.put("complexObject", complex);
        args.put("pingComplexObject", wrapper);

        MethodInvocation invocation = new MethodInvocation();
        invocation.setArguments(new Object[]{args});
        invocation.setTargetObject(method);
        WSMethodParameterMappingAspect aspect = new WSMethodParameterMappingAspect();
        Object[] result = (Object[]) aspect.getParameterInRightPositionArray(invocation);
        assertNotNull(result[0]);
        assertNotNull(result[1]);
        assertEquals(date, ((ComplexObject) result[0]).getCalendarField());
        assertEquals("Testing with AOP", ((ComplexObject) result[0]).getStringField());
        assertEquals((Integer)1, ((ComplexObject) result[0]).getIntegerField());
        assertEquals("Dexter", result[1]);

    }

    @Test
    public void jaxbBindingsFile() throws Throwable
    {
        WiseProperties props = WiseProperties.newInstance(workingDir);
        props.setProperty("wise.forceImportObject", "true");
        props.setProperty("wise.targetPackage", "org.jboss.soa.esb.actions.soap.wise.generated");
        props.setProperty("wise.keepGeneratedSources", "true");
        props.setProperty("wise.wsImporter.verbose", "true");

        // Test with no bindings file
        WSDynamicClient client = new WSDynamicClient(props);
        assertNotNull(client);
        client.init(getClass().getResource("wrappedservice.wsdl").toExternalForm(), "wrappedservice", null, null);
        Class complexObject = client.getClassLoader().loadClass("org.jboss.soa.esb.actions.soap.wise.generated.ComplexObject");
        Class pingComplexObject = client.getClassLoader().loadClass("org.jboss.soa.esb.actions.soap.wise.generated.PingComplexObject");
        Class pingComplexObjectResponse = client.getClassLoader().loadClass("org.jboss.soa.esb.actions.soap.wise.generated.PingComplexObjectResponse");
        assertNotNull(complexObject);
        assertNotNull(pingComplexObject);
        assertNotNull(pingComplexObjectResponse);
        // Strange Junit returns null if it is not Serializable :(
        assertTrue((complexObject instanceof Serializable? true: false));
        assertTrue((pingComplexObject instanceof Serializable? true: false));
        assertTrue((pingComplexObjectResponse instanceof Serializable? true: false));

        // Test with serializable bindings file
        props.setProperty("wise.jaxb.bindings", "org/jboss/soa/esb/actions/soap/wise/serialize.xjb");
        client = new WSDynamicClient(props);
        assertNotNull(client);
        client.init(getClass().getResource("wrappedservice.wsdl").toExternalForm(), "wrappedservice", null, null);
        complexObject = client.getClassLoader().loadClass("org.jboss.soa.esb.actions.soap.wise.generated.ComplexObject");
        pingComplexObject = client.getClassLoader().loadClass("org.jboss.soa.esb.actions.soap.wise.generated.PingComplexObject");
        pingComplexObjectResponse = client.getClassLoader().loadClass("org.jboss.soa.esb.actions.soap.wise.generated.PingComplexObjectResponse");
        assertNotNull(complexObject);
        assertNotNull(pingComplexObject);
        assertNotNull(pingComplexObjectResponse);
        assertTrue(complexObject instanceof Serializable);
        assertTrue(pingComplexObject instanceof Serializable);
        assertTrue(pingComplexObjectResponse instanceof Serializable);

    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SOAPClientAspectUnitTest.class);
    }

}
