/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.soa.esb.server;

import java.io.ByteArrayInputStream;
import java.io.File;

import javax.management.ObjectName;
import javax.management.ReflectionException;

import junit.framework.Test;

import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.test.JBossTestCase;

/**
 * TestCase to test dependee's re-deployment and property substitution between a dependent's restarts.
 *
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */

public class JBESB_2874_DeployUnitTest extends JBossTestCase
{
   static boolean deployed = false;
   static int test = 0;

   public JBESB_2874_DeployUnitTest(String name)
   {
      super(name);
   }

   public void testDeployment() throws Exception
   {
      ObjectName sysProps = new ObjectName("jboss:name=SystemProperties,type=Service");
      ObjectName esbDeployment = new ObjectName("jboss.esb:deployment=webgateway.esb");
      ObjectName esbDepends = new ObjectName("jboss.esb:deployment=simple.esb");
      String[] sig = {String.class.getName()};
      Object[] args = {"jboss.server.temp.dir"};

      String tmpdir = (String)invoke(sysProps, "get", args, sig);
      File tempFile = new File(tmpdir + File.separator + "esbwarfiles" + File.separator + "webgateway.war");
      assertTrue(tempFile.getPath() + " was not created!", tempFile.exists());

      String jbossEsbXml = (String)invoke(esbDeployment, "getJbossEsbXml", new Object[]{}, new String[]{});
      String expected = "expected_JBESB_2874_01.xml";
      assertTrue("Generated jboss-esb.xml not as expected. See " + expected + ".  Generated xml: \n" + 
                    jbossEsbXml, XMLHelper.compareXMLContent(getClass().getResourceAsStream(expected), new ByteArrayInputStream(jbossEsbXml.getBytes())));

      // Modify the system property between deployment
      sig = new String[] {String.class.getName(), String.class.getName()};
      args = new Object[] {"esb.test.prop.service.name", "ModifiedHelloWorldPubService"};
      invoke(sysProps, "set", args, sig);

      // Undeploy the depends service
      undeploy("simple.esb");
      // Temp war file should be undeployed and deleted by now
      assertFalse(tempFile.getPath() + " was not deleted!", tempFile.exists());

      // Deploy the depends service
      redeploy("simple.esb");
      // Temp war file should be recreated by now
      assertTrue(tempFile.getPath() + " was not re-created!", tempFile.exists());

      jbossEsbXml = (String)invoke(esbDeployment, "getJbossEsbXml", new Object[]{}, new String[]{});
      expected = "expected_JBESB_2874_02.xml";
      assertTrue("Generated jboss-esb.xml not as expected. See " + expected + ".  Generated xml: \n" + 
                    jbossEsbXml, XMLHelper.compareXMLContent(getClass().getResourceAsStream(expected), new ByteArrayInputStream(jbossEsbXml.getBytes())));
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(JBESB_2874_DeployUnitTest.class, "sysprop.war, simple.esb, webgateway.esb");
   }

}
