/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.server.jbpmAsync;

import java.io.InputStream;

import org.jboss.soa.esb.util.ClassUtil;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;

/**
 * MBean to manage jBPM Asynchronous callback tests.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JbpmServer implements JbpmServerMBean
{
    private static final String PROCESS_DEFINITION = "/jbpmAsyncTest.xml" ;
    
    private boolean suspendProcess ;
    
    private long processInstanceId ;
    
    public synchronized void startProcess()
    {
        final JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance() ;
        final JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext() ;
        
        // Create process definition
        final InputStream is = ClassUtil.getResourceAsStream(PROCESS_DEFINITION, getClass()) ;
        final ProcessDefinition processDefinition = ProcessDefinition.parseXmlInputStream(is) ;
        jbpmContext.deployProcessDefinition(processDefinition) ;
        
        // Create process instance
        final ProcessInstance processInstance = jbpmContext.newProcessInstance(processDefinition.getName()) ;
        processInstanceId = processInstance.getId() ;
        
        // Start process instance
        processInstance.signal() ;
        
        jbpmContext.close() ;
    }
    
    public synchronized void suspendProcessInstance()
    {
        if (suspendProcess)
        {
            final JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance() ;
            final JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext() ;
            
            final ProcessInstance processInstance = jbpmContext.loadProcessInstance(processInstanceId) ;
            processInstance.suspend() ;
            
            jbpmContext.close() ;
        }
    }
    
    public synchronized void resumeProcessInstance()
    {
        if (suspendProcess)
        {
            final JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance() ;
            final JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext() ;
            
            final ProcessInstance processInstance = jbpmContext.loadProcessInstance(processInstanceId) ;
            processInstance.resume() ;
            
            jbpmContext.close() ;
        }
    }
    
    public synchronized void setSuspendProcess(final boolean suspendProcess)
    {
        this.suspendProcess = suspendProcess ;
    }
    
    public boolean checkWaitingAction(final long delay)
    {
        return JbpmAsyncActionHandler.notifyAction(delay) ;
    }
}
