/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server.sysprop;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import org.apache.log4j.Logger;

/**
 * A Servlet that initializes certain System properties needed by junit tests.
 *
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 * @version $Revision: 1.0 $
 */
public class SysPropServlet extends HttpServlet
{
    private Logger log = Logger.getLogger(SysPropServlet.class);

    public void init(ServletConfig config) throws ServletException
    {
        super.init(config);
        System.setProperty("esb.test.prop.service.name", "HelloWorldPubService");
        log.info("System properties initialized!");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        PrintWriter pw = new PrintWriter (response.getOutputStream());
        pw.println("Not Implemented!");
        pw.close();
    }
}
