package org.jboss.soa.esb.quickstart.test;

import java.io.File;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.webserviceproducer.test.SendMessage;
import org.jboss.soa.esb.testutils.FileUtil;

/**
 * CI test for the webservice_producer quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class WebServiceProducerTest extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "jms";
	private static final String RESULT_STRING = "<env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>"
			+ "<env:Header></env:Header><env:Body><ns2:sayGoodbyeResponse xmlns:ns2=\"http://webservice_producer/goodbyeworld\">"
			+ "<return>... Ah Goodbye then!!!! - Goodbye!!</return></ns2:sayGoodbyeResponse></env:Body></env:Envelope>";

	public WebServiceProducerTest(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendMessage() ;
	    String[] sinkMessages = waitForMessages(1, 30000);
	    assertTrue("Expected to find string " + RESULT_STRING + " found " + sinkMessages[0],
	    		sinkMessages[0].equals(RESULT_STRING));
	}

	public void sendMessage() throws Exception {
        SendMessage sm = new SendMessage();
        String location = Helpers.getQuickstartLocation("webservice_producer/src/org/jboss/soa/esb/samples/quickstart/webserviceproducer/test/soap_message_01.xml");
        File file = new File(location);
		String targetString = FileUtil.readTextFile(file);
        sm.sendMessageOverJMS(targetString);
	}

	public static Test suite() throws Exception {
		return getDeploySetup(WebServiceProducerTest.class, "QuickstartMessageStoreServer.sar, Quickstart_webservice_producer.esb");
	}
}
