package org.jboss.soa.esb.quickstart.test;

import java.io.InputStream;

import junit.framework.Test;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.internal.soa.esb.util.StreamUtils;

import org.jboss.soa.esb.samples.quickstart.webservice_proxy_versioning.test.SendWSMessage;

public class WebServiceProxyVersioningTest extends AbstractQuickstartTestCase {
	public WebServiceProxyVersioningTest(String name) {
		super(name);
	}

    private static final String SOAP_PRE =
        "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:inv=\"http://webservice_proxy_versioning/invoicing\">" +
                "<soapenv:Header/>" +
                "<soapenv:Body>" +
                        "<inv:processInvoice>" +
                                "<invoiceNumber>0123456789</invoiceNumber>";

    private static final String SOAP_POST =
                        "</inv:processInvoice>" +
                "</soapenv:Body>" +
        "</soapenv:Envelope>";
	
	public void testWS() throws Exception {
		clearMessages();
		SendWSMessage ws = new SendWSMessage();

        String url = "http://localhost:8080/Quickstart_webservice_proxy_versioning/http/Proxy_Versioning/Proxy-OldVersion"; // the old ws format ("ant runold" or "ant runtest")
        String versionstring = "old";

        System.out.println("****  REQUEST  URL: " + url);
        PostMethod method = new PostMethod(url);
        method.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");

        // this line should be used for better performance/interop but is not necessary
        // http://www.w3.org/TR/2000/NOTE-SOAP-20000508/#_Toc478383528
        // http://www.ws-i.org/Profiles/BasicProfile-1.1.html#SOAPAction_HTTP_Header
        method.setRequestHeader("SOAPAction", "\"\"");

        boolean old = "old".equals(versionstring);
        String request = SOAP_PRE + (old ? "" : "<processDate>2005-12-13T14:13:28.443+01:00</processDate>") + SOAP_POST;
        System.out.println("****  REQUEST BODY: " + request);
        method.setRequestEntity( new StringRequestEntity(request) );

        HttpClient client = new HttpClient();
        InputStream response = null;
        try
        {
                int code = client.executeMethod(method);
                System.out.println("**** RESPONSE CODE: " + code);

                response = method.getResponseBodyAsStream();
                byte[] bytes = StreamUtils.readStream(response);
                System.out.println("**** RESPONSE BODY: " + new String(bytes, method.getResponseCharSet()));
        }
        finally
        {
                method.releaseConnection();
                if (response != null)
                {
                        response.close();
                }
        }

		
	}

	public static Test suite() throws Exception {
		return getDeploySetup(WebServiceProxyVersioningTest.class, "QuickstartMessageStoreServer.sar, Quickstart_webservice_proxy_versioning_ws.war, Quickstart_webservice_proxy_versioning.esb");
	}	
}
