/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;

/**
 * This interface defines the component responsible for initializing the
 * JAX-WS compliant web service stack. Although JAX-WS provides a standard
 * API for communicating with external web services, it does not provide
 * standardisation for the initialization of high layers of the web
 * stack, e.g. related to WS-Security. Therefore, specific initialization
 * is required on a per stack basis.
 * 
 * @author gbrown
 *
 */
public interface JAXWSInitializer {

	/**
	 * This method initializes the web service stack in preparation for
	 * calling the service and port supplied as parameters.
	 * 
	 * @param serviceName The service name
	 * @param portName The port name
	 * @param baseURI The base URI of the deployment
	 */
	public void initializeStack(QName serviceName, QName portName, java.net.URI baseURI);
	
	/**
	 * This method is used to notify the initializer that the service has
	 * not been created.
	 * 
	 */
	@Deprecated
	public void serviceCreated();
	
	/**
	 * This method is used to notify the initializer that the service has
	 * not been created.
	 * 
	 * @param serviceName The service name
	 * @param portName The port name
	 * @param baseURI The base URI of the deployment
	 * @param dispatch The dispatcher
	 */
	public void serviceCreated(QName serviceName, QName portName, java.net.URI baseURI,
						Dispatch<SOAPMessage> dispatcher);
	
}
