package org.jboss.soa.bpel.samples.quickstart.ws;

import java.util.HashMap;
import java.util.Map;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

/**
 *
 * @author mbaluch
 */
@WebService(name="FibonacciWS", targetNamespace="http://jboss.org/fibonacii")
public class Fibonacci {

    IDGenerator gen = new IDGenerator();
    Map<Long, FibonacciCounter> tasks = new HashMap<Long, FibonacciCounter>();
    
    @WebMethod(operationName = "computeFibonacciRow")
    public long fibonacci(@WebParam(name = "n") int n) {
        Long id = new Long(gen.next());
        FibonacciCounter fibCounter = new FibonacciCounter(n);
        fibCounter.start();

        tasks.put(id, fibCounter);
        return id;
    }

    @WebMethod(operationName = "getResult")
    public String getResult(@WebParam(name = "id") long id) throws Exception {
        if(!tasks.keySet().contains(id)) {
            throw new Exception("No task with ID=" + id);
        }

        FibonacciCounter counter = tasks.get(id);
        // Shouldn't return <code>null</code> value. BPEL does not like that.
        return (counter.isAlive()) ?
            "" :
            tasks.remove(id).getResult();
    }

}
