AntBuilder ant=new AntBuilder()
Binding binding = new Binding(this.binding.variables)
GroovyShell gs = new GroovyShell(binding)
components = project.properties['components'].split(",") 
scanner = ant.fileScanner
{
    fileset(dir:project.basedir)
    {
        include(name:'src/test/**/*.xml')
        include(name:'src/test/**/*.groovy')
    }
}  
for(testFile in scanner)
{
    println "execute test:"+testFile
    if(testFile.name.endsWith(".xml"))
    {
        ant.ant(antfile:testFile, target:"execute.test")
        {
            property(name:"project.version", value:project.version)
            property(name:"project.artifactId", value:project.artifactId)
            for(prop in project.properties)
            {
                property(name:prop.key, value:prop.value)
            }
        }
    }
    else if(testFile.name.endsWith(".groovy"))
    {
        gs.evaluate(testFile)
    }
}

