/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.richfaces.exception.FileUploadException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.UploadedFile;
import org.richfaces.request.ByteSequenceMatcher;
import org.richfaces.request.FileUploadDiscResource;
import org.richfaces.request.FileUploadMemoryResource;
import org.richfaces.request.FileUploadParam;
import org.richfaces.request.FileUploadValueParam;
import org.richfaces.request.ProgressControl;
import org.richfaces.request.UploadedFile25;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipartRequestParser {
    static final String PARAM_NAME = "name";
    static final String PARAM_FILENAME = "filename";
    static final String PARAM_CONTENT_TYPE = "Content-Type";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final byte[] HYPHENS = new byte[]{45, 45};
    private static final int BUFFER_SIZE = 2048;
    private static final int CHUNK_SIZE = 1024;
    private static final int MAX_HEADER_SIZE = 32768;
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile(".*filename=\"(.*)\"");
    private static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("^\\s*([^\\s=]+)\\s*[=:]\\s*(.+)\\s*$");
    private static final ByteSequenceMatcher.BytesHandler NOOP_HANDLER = new ByteSequenceMatcher.BytesHandler(){

        public void handle(byte[] bytes, int length) {
        }
    };
    private HttpServletRequest request;
    private boolean createTempFiles;
    private String tempFilesDirectory;
    private Multimap<String, String> parametersMap = LinkedListMultimap.create();
    private List<UploadedFile> uploadedFiles = Lists.newArrayList();
    private byte[] boundaryMarker;
    private ByteSequenceMatcher sequenceMatcher;
    private HeadersHandler headersHandler;
    private ProgressControl progressControl;

    public MultipartRequestParser(HttpServletRequest request, boolean createTempFiles, String tempFilesDirectory, ProgressControl progressControl) {
        this.request = request;
        this.createTempFiles = createTempFiles;
        this.tempFilesDirectory = tempFilesDirectory;
        this.progressControl = progressControl;
    }

    private void cancel() {
        for (UploadedFile uploadedFile : this.uploadedFiles) {
            try {
                uploadedFile.delete();
            }
            catch (IOException e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Multimap<String, String> getParameters() {
        return this.parametersMap;
    }

    public Iterable<UploadedFile> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public void parse() throws FileUploadException {
        try {
            this.initialize();
            while (!this.sequenceMatcher.isEOF()) {
                this.readNext();
            }
        }
        catch (IOException e) {
            this.cancel();
            throw new FileUploadException(MessageFormat.format("Exception parsing multipart request: {0}", e.getMessage()), (Throwable)e);
        }
    }

    private void initialize() throws IOException, FileUploadException {
        this.boundaryMarker = this.getBoundaryMarker(this.request.getContentType());
        if (this.boundaryMarker == null) {
            throw new FileUploadException("The request was rejected because no multipart boundary was found");
        }
        if (HYPHENS.length + this.boundaryMarker.length + 1024 + CR_LF.length > 2048) {
            throw new FileUploadException("Boundary marker is too long");
        }
        this.sequenceMatcher = new ByteSequenceMatcher((InputStream)this.progressControl.wrapStream(this.request.getInputStream()), 2048);
        this.readProlog();
    }

    private String getFirstParameterValue(Multimap<String, String> multimap, String key) {
        Collection values = multimap.get((Object)key);
        if (values.isEmpty()) {
            return null;
        }
        return (String)Iterables.get((Iterable)values, (int)0);
    }

    private byte[] getBoundaryMarker(String contentType) {
        Multimap<String, String> params = this.parseParams(contentType, ";");
        String boundaryStr = this.getFirstParameterValue(params, "boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            return boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return boundaryStr.getBytes();
        }
    }

    private Multimap<String, String> parseParams(String paramStr, String separator) {
        LinkedListMultimap paramMap = LinkedListMultimap.create();
        this.parseParams(paramStr, separator, (Multimap<String, String>)paramMap);
        return paramMap;
    }

    private void parseParams(String paramStr, String separator, Multimap<String, String> paramMap) {
        String[] parts;
        for (String part : parts = paramStr.split(separator)) {
            Matcher m = PARAM_VALUE_PATTERN.matcher(part);
            if (!m.matches()) continue;
            String key = m.group(1).toLowerCase(Locale.US);
            String value = m.group(2);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (!PARAM_FILENAME.equals(key)) {
                paramMap.put((Object)key, (Object)value);
                continue;
            }
            paramMap.put((Object)key, (Object)this.parseFileName(paramStr));
        }
    }

    private String decodeFileName(String name) {
        String fileName = null;
        try {
            StringBuilder builder = new StringBuilder();
            String[] codes = name.split(";");
            if (codes != null) {
                for (String code : codes) {
                    if (code.startsWith("&")) {
                        String sCode = code.replaceAll("[&#]*", "");
                        Integer iCode = Integer.parseInt(sCode);
                        builder.append(Character.toChars(iCode));
                        continue;
                    }
                    builder.append(code);
                }
                fileName = builder.toString();
            }
        }
        catch (Exception e) {
            fileName = name;
        }
        return fileName;
    }

    private String parseFileName(String parseStr) {
        Matcher m = FILE_NAME_PATTERN.matcher(parseStr);
        if (m.matches()) {
            String name = m.group(1);
            if (name.startsWith("&")) {
                return this.decodeFileName(name);
            }
            return name;
        }
        return null;
    }

    private void readProlog() throws IOException {
        this.sequenceMatcher.setBytesHandler(NOOP_HANDLER);
        this.sequenceMatcher.findSequence(-1, HYPHENS, this.boundaryMarker);
        if (!this.sequenceMatcher.isMatchedAndNotEOF()) {
            throw new IOException("Request prolog cannot be read");
        }
    }

    private void readData(FileUploadParam uploadParam) throws IOException {
        this.sequenceMatcher.setBytesHandler(uploadParam);
        this.sequenceMatcher.findSequence(1024, CR_LF, HYPHENS, this.boundaryMarker);
        this.sequenceMatcher.setBytesHandler(null);
        if (!this.sequenceMatcher.isMatchedAndNotEOF()) {
            throw new IOException("Request data cannot be read");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNext() throws IOException {
        Multimap<String, String> headers = this.readHeaders();
        FileUploadParam param = this.createParam(headers);
        if (param == null) {
            return;
        }
        param.create();
        try {
            this.readData(param);
        }
        finally {
            param.complete();
        }
        if (param.isFileParam()) {
            this.uploadedFiles.add(new UploadedFile25(param.getName(), param.getResource(), headers));
        } else {
            this.parametersMap.put((Object)param.getName(), (Object)param.getValue());
        }
    }

    private FileUploadParam createParam(Multimap<String, String> headers) {
        boolean isFile;
        if (headers == null) {
            return null;
        }
        String parameterName = this.getFirstParameterValue(headers, PARAM_NAME);
        if (Strings.isNullOrEmpty((String)parameterName)) {
            return null;
        }
        boolean bl = isFile = !Strings.isNullOrEmpty((String)this.getFirstParameterValue(headers, PARAM_FILENAME));
        FileUploadParam param = isFile ? (this.createTempFiles ? new FileUploadDiscResource(parameterName, this.tempFilesDirectory) : new FileUploadMemoryResource(parameterName, this.tempFilesDirectory)) : new FileUploadValueParam(parameterName, this.request.getCharacterEncoding());
        return param;
    }

    private Multimap<String, String> readHeaders() throws IOException {
        if (this.sequenceMatcher.isEOF()) {
            return null;
        }
        if (this.headersHandler == null) {
            this.headersHandler = new HeadersHandler();
        } else {
            this.headersHandler.reset();
        }
        this.sequenceMatcher.setBytesHandler(this.headersHandler);
        this.sequenceMatcher.findSequence(-1, new byte[][]{CR_LF});
        if (this.sequenceMatcher.isMatchedAndNotEOF() && !this.headersHandler.dataEquals(HYPHENS)) {
            String[] split;
            this.headersHandler.reset();
            this.sequenceMatcher.findSequence(-1, CR_LF, CR_LF);
            if (!this.sequenceMatcher.isMatchedAndNotEOF()) {
                throw new IOException("Request header cannot be read");
            }
            String headersString = this.headersHandler.asString();
            LinkedListMultimap headers = LinkedListMultimap.create();
            for (String headerString : split = headersString.split("\r\n")) {
                this.parseParams(headerString, "; ", (Multimap<String, String>)headers);
            }
            return headers;
        }
        return null;
    }

    private class HeadersHandler
    implements ByteSequenceMatcher.BytesHandler {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);

        private HeadersHandler() {
        }

        public void handle(byte[] bytes, int length) throws IOException {
            if (length != 0) {
                if (this.baos.size() + length > 32768) {
                    throw new IOException("Header section is too big");
                }
                this.baos.write(bytes, 0, length);
            }
        }

        public boolean dataEquals(byte[] bytes) {
            return this.baos.size() == bytes.length && Arrays.equals(HYPHENS, this.baos.toByteArray());
        }

        public String asString() throws UnsupportedEncodingException {
            if (MultipartRequestParser.this.request.getCharacterEncoding() != null) {
                return this.baos.toString(MultipartRequestParser.this.request.getCharacterEncoding());
            }
            return this.baos.toString();
        }

        public void reset() {
            this.baos.reset();
        }
    }
}

