__author__ = 'slaskawi@redhat.com'

import os
import logging
import subprocess


class LocalBuilder:
    def __init__(self, configuration):
        self._configuration = configuration

    def build_locally_jdg(self):
        logging.info("Building distribution")
        os.system(
            "./" + self._configuration.get_productization_repo_location() + "/build.sh clean install -DskipTests -Pdistribution")

    def build_locally_packaging(self):
        logging.info("Building from packaging")
        os.system(
            "./" + self._configuration.get_packaging_repo_location() + "/build.sh")

    def prepare_dependency_information(self):
        logging.info("Preparing dependency list")
        return_to_this_dir = os.getcwd()
        try:
            os.chdir(self._configuration.get_packaging_repo_location())
            command = ["./bin/dependency-report.sh"]
            command.extend(["--projects", self._configuration.get_productization_repo_location()])
            logging.debug("Invoking dependency report with arguments: " + str(command))
            subprocess.check_call(command)
        finally:
            os.chdir(return_to_this_dir)