
 package org.infinispan.marshall.exts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.io.ExpandableMarshalledValueByteStream;
import org.infinispan.marshall.core.VersionAwareMarshaller;
import org.testng.annotations.Test;

import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertEquals;

 @Test(groups = "functional", testName = "marshall.exts.TestMapDifferentSerializedForms")
public class TestMapDifferentSerializedForms {

    private <T> byte[] getSerializedForm(Externalizer<? super T> externalizer, T object) throws IOException {
       ExpandableMarshalledValueByteStream baos = new ExpandableMarshalledValueByteStream();
       ObjectOutput output = new ObjectOutputStream(baos);
       externalizer.writeObject(output, object);
       return baos.getRaw();
    }

    /**
     * This tests to just make sure the serialized form is different, otherwise tests will report false positives
     * @throws IOException
     */
    public void testEnsureSerializedFormsDifferent() throws IOException {
       MapExternalizer externalizer = new MapExternalizer();
       MapExternalizer.InstanceReusingMapExternalizer reuseExternalizer = new MapExternalizer.InstanceReusingMapExternalizer();

       Map<String, String> mapToUse = new HashMap<String, String>();
       mapToUse.put("key", "value");

       byte[] bytes = getSerializedForm(externalizer, mapToUse);

       byte[] reuseBytes = getSerializedForm(reuseExternalizer, mapToUse);

       assertFalse(Arrays.equals(bytes, reuseBytes));
    }

    public void testEnsureMapExternalizerCanReadItself() throws IOException, ClassNotFoundException {
       MapExternalizer externalizer = new MapExternalizer();

       Map<String, String> mapToUse = new HashMap<String, String>();
       mapToUse.put("key", "value");

       byte[] bytes = getSerializedForm(externalizer, mapToUse);

       try {
          // We have to set this to have it read in the same manner
          VersionAwareMarshaller.performRetrySerialization.set(true);
          assertEquals(mapToUse, externalizer.readObject(new ObjectInputStream(new ByteArrayInputStream(bytes))));
       } finally {
          VersionAwareMarshaller.performRetrySerialization.remove();
       }
    }

    public void testEnsureMapExternalizerCanReadReuseSerialization() throws IOException, ClassNotFoundException {
       MapExternalizer externalizer = new MapExternalizer();
       MapExternalizer.InstanceReusingMapExternalizer reuseExternalizer = new MapExternalizer.InstanceReusingMapExternalizer();

       Map<String, String> mapToUse = new HashMap<String, String>();
       mapToUse.put("key", "value");

       byte[] bytes = getSerializedForm(reuseExternalizer, mapToUse);

       // Note we are using the other externalizer to read this
       assertEquals(mapToUse, externalizer.readObject(new ObjectInputStream(new ByteArrayInputStream(bytes))));
    }
}
