/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.converter;

import java.util.Date;
import java.util.TimeZone;

import org.apache.camel.Converter;

/**
 * Date and time related converters.
 */
@Converter
public final class DateTimeConverter {

    /**
     * Utility classes should not have a public constructor.
     */
    private DateTimeConverter() {
    }

    @Converter
    public static TimeZone toTimeZone(String s) {
        return TimeZone.getTimeZone(s);
    }
    
    @Converter
    public static Date toDate(Long l) {
        return l != null ? new Date(l) : null;
    }
    
    @Converter
    public static Long toLong(Date date) {
        return date != null ? date.getTime() : null;
    }
}
