package org.infinispan.cdi.test.interceptor;

import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CachePutInterceptor;
import org.infinispan.cdi.interceptor.DefaultCacheKey;
import org.infinispan.cdi.test.interceptor.config.Config;
import org.infinispan.cdi.test.interceptor.config.Custom;
import org.infinispan.cdi.test.interceptor.service.CachePutService;
import org.infinispan.cdi.test.interceptor.service.CustomCacheKey;
import org.infinispan.cdi.test.testutil.Deployments;
import org.infinispan.manager.CacheContainer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.cache.annotation.CacheKey;
import javax.inject.Inject;
import java.lang.reflect.Method;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertTrue;

/**
 * @author Kevin Pollet <kevin.pollet@serli.com> (C) 2011 SERLI
 * @see javax.cache.annotation.CachePut
 */
@Test(groups = "functional", testName = "cdi.test.interceptor.CachePutInterceptorTest")
public class CachePutInterceptorTest extends Arquillian {

   @Deployment
   public static Archive<?> deployment() {
      return Deployments.baseDeployment()
            .addClass(CachePutInterceptor.class)
            .addPackage(CachePutService.class.getPackage())
            .addPackage(Config.class.getPackage());
   }

   @Inject
   private CachePutService service;

   @Inject
   private CacheContainer cacheContainer;

   @Custom
   @Inject
   private Cache<CacheKey, String> customCache;

   @BeforeMethod
   public void beforeMethod() {
      customCache.clear();
      assertTrue(customCache.isEmpty());
   }

   @Test
   public void testCachePut() {
      final StringBuilder cacheName = new StringBuilder()
            .append(CachePutService.class.getName())
            .append(".put(long,java.lang.String)");
      System.out.println("CacheName: " + cacheName);

      final Cache<CacheKey, String> cache = cacheContainer.getCache(cacheName.toString());
      service.put(0l, "Manik");
      service.put(0l, "Kevin");
      service.put(1l, "Pete");

      assertEquals(2, cache.size());
      assertTrue(cache.containsKey(new DefaultCacheKey(new Object[]{0l})));
      assertTrue(cache.containsKey(new DefaultCacheKey(new Object[]{1l})));
   }

   @Test
   public void testCachePutWithCacheName() {
      service.putWithCacheName(0l, "Manik");
      service.putWithCacheName(0l, "Kevin");
      service.putWithCacheName(1l, "Pete");

      System.out.println("Custom cache from test: " + customCache);
      assertEquals(2, customCache.size());
      assertTrue(customCache.containsKey(new DefaultCacheKey(new Object[]{0l})));
      assertTrue(customCache.containsKey(new DefaultCacheKey(new Object[]{1l})));
   }

   @Test
   public void testCachePutCacheKeyParam() {
      service.putWithCacheKeyParam(0l, 1l, "Manik");
      service.putWithCacheKeyParam(0l, 1l, "Kevin");
      service.putWithCacheKeyParam(1l, 2l, "Pete");

      assertEquals(2, customCache.size());
      assertTrue(customCache.containsKey(new DefaultCacheKey(new Object[]{0l})));
      assertTrue(customCache.containsKey(new DefaultCacheKey(new Object[]{1l})));
   }

   @Test
   public void testCachePutBeforeInvocation() {
      try {

         service.putBeforeInvocation(0l, "Manik");

      } catch (RuntimeException e) {
         assertEquals(customCache.size(), 1);
      }
   }

   @Test
   public void putWithCacheKeyGenerator() throws Exception {
      final Method method = CachePutService.class.getMethod("putWithCacheKeyGenerator", Long.TYPE, String.class);

      service.putWithCacheKeyGenerator(0l, "Manik");
      service.putWithCacheKeyGenerator(0l, "Manik");
      service.putWithCacheKeyGenerator(1l, "Pete");

      assertEquals(2, customCache.size());
      assertTrue(customCache.containsKey(new CustomCacheKey("put", "Manik")));
      assertTrue(customCache.containsKey(new CustomCacheKey("put", "Pete")));
   }
}
