package org.infinispan.client.hotrod.impl.iteration;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.testng.annotations.Test;

import java.util.Map.Entry;
import java.util.Set;

import static org.infinispan.client.hotrod.impl.iteration.RemoteIteratorTestUtils.*;
import static org.testng.Assert.assertEquals;

/**
 * @author gustavonalle
 * @since 8.2
 */
@Test(groups = "functional", testName = "client.hotrod.iteration.SegmentFilteredFailOverTest")
public class SegmentFilteredFailOverTest extends DistFailOverRemoteIteratorTest {

   static final int ENTRIES = 100;

   private int count(RemoteCacheManager remoteCacheManager, Set<Integer> segments) {
      Marshaller marshaller = remoteCacheManager.getMarshaller();
      RemoteCache<Integer, ?> remoteCache = remoteCacheManager.getCache();
      ConsistentHash hash = advancedCache(0).getDistributionManager().getConsistentHash();
      int size = 0;
      for (Integer key : remoteCache.keySet()) {
         if (segments.contains(hash.getSegment(toByteBuffer(key, marshaller)))) {
            size ++;
         }
      }
      return size;
   }

   @Override
   public void testFailOver() throws InterruptedException {
      RemoteCache<Integer, AccountHS> remoteCache = clients.get(0).getCache();


      populateCache(ENTRIES, new Function<Integer, AccountHS>() {
         @Override
         public AccountHS apply(Integer id) {
            return newAccount(id);
         }
      }, remoteCache);

      Cache<Object, Object> cache = caches().get(0);
      int totalSegments = cache.getCacheConfiguration().clustering().hash().numSegments();

      Set<Integer> segments = range(0, totalSegments / 2);

      long expectedCount = count(remoteCache.getRemoteCacheManager(), segments);

      int actualCount = 0;

      CloseableIterator<Entry<Object, Object>> iterator = null;
      try {
         iterator = remoteCache.retrieveEntries(null, segments, 9);
         for (int i = 0; i < ENTRIES / 5; i++) {
            iterator.next();
            actualCount++;
         }

         killIterationServer();

         while (iterator.hasNext()) {
            iterator.next();
            actualCount++;
         }
      } finally {
         if (iterator != null) {
            iterator.close();
         }

      }

      assertEquals(actualCount, expectedCount);
   }
}
