package org.apache.camel.component.infinispan.blueprint;

import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.infinispan.InfinispanConstants;
import static org.apache.camel.component.infinispan.InfinispanConstants.KEY;
import static org.apache.camel.component.infinispan.InfinispanConstants.VALUE;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.blueprint.CamelBlueprintTestSupport;
import org.junit.Test;

public class InfinispanLocalConsumerCustomListenerBlueprintIT extends CamelBlueprintTestSupport {
    
    @EndpointInject(uri = "mock:result")
    private MockEndpoint mockResult;

    @Override
    protected String getBlueprintDescriptor() {
        return "custom-listener-blueprint.xml";
    }
    
    @Test
    public void createEventConsumed() throws InterruptedException {
        //One for the existing entry and one for the new entry.
        mockResult.expectedMessageCount(2);

        Exchange request = template.request("direct:put",
                    new Processor() {
                        @Override
                        public void process(Exchange exchange) throws Exception {
                            Message in = exchange.getIn();
                            in.setHeader(KEY, "newKey");
                            in.setHeader(VALUE, "newValue");
                        }
                    });
        assertNull(request.getException());
        
        mockResult.message(0).outHeader(InfinispanConstants.IS_PRE).isEqualTo(true);
        mockResult.message(0).outHeader(InfinispanConstants.KEY).isEqualTo("newKey");
        mockResult.message(1).outHeader(InfinispanConstants.IS_PRE).isEqualTo(false);

        mockResult.assertIsSatisfied();
    }
}
