package org.infinispan.commons.util;

import java.util.BitSet;

/**
 * @author gustavonalle
 */
public final class BitSetUtils {

   public static byte[] toByteArray(BitSet bits) {
      int size = ((bits.length() + 7) & ~0x7) / 8;
      byte[] bytes = new byte[size];
      for (int i = 0; i < bits.length(); i++) {
         if (bits.get(i)) {
            bytes[i / 8] |= 1 << (i % 8);
         }
      }
      return bytes;
   }

   public static BitSet fromByteArray(byte[] bytes) {
      BitSet bitSet = new BitSet();
      for (int i = 0; i < bytes.length * 8; i++) {
         if ((bytes[i / 8] & (1 << (i % 8))) > 0) {
            bitSet.set(i);
         }
      }
      return bitSet;
   }

}
