package org.apache.camel.itest.eap;

import org.apache.camel.component.infinispan.InfinispanClusteredConsumerTest;
import org.infinispan.test.fwk.TestResourceTracker;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;

import static org.apache.camel.itest.eap.utils.DeploymentBuilder.baseDeploymentEmbedded;

@RunWith(Arquillian.class)
public class InfinispanClusteredConsumerIT extends InfinispanClusteredConsumerTest {

   @Deployment
   public static Archive<?> deployment() {
      return baseDeploymentEmbedded()
              .addClass(InfinispanClusteredConsumerTest.class);
   }

   @Override
   @Before
   public void setUp() throws Exception {
      //the test methods run in the container in a different thread, need to set the thread name
      //at this point
      TestResourceTracker.testStarted(InfinispanClusteredConsumerIT.class.getName());
      super.setUp();
   }

   @Override
   @After
   public void tearDown() throws Exception {
      TestResourceTracker.testFinished(InfinispanClusteredConsumerIT.class.getName());
      super.tearDown();
   }
}
