/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.client;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactoryImpl;
import com.metamatrix.common.comm.platform.client.ServerAdminClientInterceptor;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactoryImpl;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.core.proxy.ServiceEndpoint;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceProxyFactory;

public class ServerAdminFactory {
    public static final String DEFAULT_APPLICATION_NAME = "Admin";
    public static final String METAMATRIX_PRODUCT_NAME = "Platform";
    private static ServerAdminFactory instance = null;
    private SocketServerConnectionFactory connectionFactory = null;
    static /* synthetic */ Class class$com$metamatrix$admin$api$server$ServerAdmin;

    private ServerAdminFactory() {
    }

    public static synchronized ServerAdminFactory getInstance() {
        if (instance == null) {
            instance = new ServerAdminFactory();
        }
        return instance;
    }

    public ServerAdmin createAdmin(String userName, char[] password, String serverURL) throws LogonException, AdminException {
        return this.createAdmin(userName, password, serverURL, DEFAULT_APPLICATION_NAME);
    }

    public ServerAdmin createAdmin(String userName, char[] password, String serverURL, String applicationName) throws LogonException, AdminException {
        if (userName == null || userName.trim().length() == 0) {
            throw new IllegalArgumentException(CommPlatformPlugin.Util.getString("ERR.014.001.0099"));
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException(CommPlatformPlugin.Util.getString("ERR.014.001.0100"));
        }
        this.initConnectionFactory();
        ServerAdmin admin = this.createAdminProxy(userName, password, serverURL, applicationName);
        return admin;
    }

    private synchronized void initConnectionFactory() {
        if (this.connectionFactory == null) {
            ClientSideLogonFactoryImpl clientSideLogonFactory = ClientSideLogonFactoryImpl.getInstance();
            ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactory();
            ObjectSocketFactoryImpl objectSocketFactory = ObjectSocketFactoryImpl.getInstance();
            this.connectionFactory = new SocketServerConnectionFactory(SocketConstants.getMaxThreads(), SocketConstants.getTTL(), SocketConstants.getSynchronousTTL(), SocketConstants.getLog("ADMIN_API_CONNECTION"), this.getClass().getClassLoader(), SocketConstants.getInputBufferSize(), SocketConstants.getOutputBufferSize(), SocketConstants.getConserveBandwidth(), clientSideLogonFactory, serviceProxyFactory, objectSocketFactory);
        }
    }

    private ServerAdmin createAdminProxy(String userName, char[] password, String serverURL, String applicationName) throws AdminException {
        ServiceInterceptor[] serviceInterceptorArray = new ServiceInterceptor[1];
        Class<?> clazz = class$com$metamatrix$admin$api$server$ServerAdmin;
        if (clazz == null) {
            clazz = class$com$metamatrix$admin$api$server$ServerAdmin = new ServerAdmin[0].getClass().getComponentType();
        }
        serviceInterceptorArray[0] = ServiceEndpoint.getAttributeSettingInterceptor(clazz);
        ServiceInterceptor[] interceptors = serviceInterceptorArray;
        ServerAdminClientInterceptor terminalInterceptor = new ServerAdminClientInterceptor(userName, password, serverURL, applicationName, this.connectionFactory);
        ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactory();
        Class<?> clazz2 = class$com$metamatrix$admin$api$server$ServerAdmin;
        if (clazz2 == null) {
            clazz2 = class$com$metamatrix$admin$api$server$ServerAdmin = new ServerAdmin[0].getClass().getComponentType();
        }
        ServerAdmin admin = (ServerAdmin)serviceProxyFactory.create(clazz2, interceptors, terminalInterceptor);
        admin.getSystem();
        return admin;
    }
}

