/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.types.BaseXMLTranslator;
import com.metamatrix.common.types.XMLReaderFactory;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XMLStreamSourceTranslator
extends BaseXMLTranslator {
    char[] srcString;
    XMLReaderFactory readerFactory;

    public XMLStreamSourceTranslator(String xmlSource, Properties props) {
        super(props);
        this.srcString = xmlSource.toCharArray();
        this.readerFactory = new CharArrayXMLReader(this.srcString);
    }

    public XMLStreamSourceTranslator(char[] xmlSource, Properties props) {
        super(props);
        this.srcString = xmlSource;
        this.readerFactory = new CharArrayXMLReader(this.srcString);
    }

    public XMLStreamSourceTranslator(StreamSource source, Properties props) {
        super(props);
        this.readerFactory = new StreamSourceXMLReader(source);
    }

    public XMLStreamSourceTranslator(XMLReaderFactory factory, Properties props) {
        super(props);
        this.readerFactory = factory;
    }

    public Source getSource() throws IOException {
        return new StreamSource(this.readerFactory.getReader());
    }

    public Reader getReader() throws IOException {
        StreamSource src = (StreamSource)this.getSource();
        if (src.getReader() != null) {
            return src.getReader();
        }
        return super.getReader();
    }

    public InputStream getInputStream() throws IOException {
        StreamSource src = (StreamSource)this.getSource();
        if (src.getInputStream() != null) {
            return src.getInputStream();
        }
        return super.getInputStream();
    }

    public String getString() throws IOException {
        if (this.srcString != null) {
            return new String(this.srcString);
        }
        return super.getString();
    }

    static class StreamSourceXMLReader
    implements XMLReaderFactory {
        StreamSource source;

        public StreamSourceXMLReader(StreamSource source) {
            this.source = source;
        }

        public Reader getReader() throws IOException {
            InputStream stream = this.source.getInputStream();
            if (stream != null) {
                return new InputStreamReader(stream);
            }
            return this.source.getReader();
        }
    }

    static class CharArrayXMLReader
    implements XMLReaderFactory {
        char[] contents;

        public CharArrayXMLReader(char[] content) {
            this.contents = content;
        }

        public Reader getReader() throws IOException {
            return new CharArrayReader(this.contents);
        }
    }
}

