/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.StringUtil;
import java.io.PrintStream;
import java.io.Serializable;

public class Stopwatch
implements Serializable {
    private long start = 0L;
    private long stop = 0L;
    private Statistics stats = new Statistics();
    private boolean active = true;
    private static final String SECONDS = CorePlugin.Util.getString("Stopwatch.seconds");
    private static final String MILLISECONDS = CorePlugin.Util.getString("Stopwatch.milliseconds");
    private static final int VALUE_LENGTH = 10;

    public boolean isActive() {
        return this.active;
    }

    public void setInactive() {
        this.active = false;
    }

    public void setActive() {
        this.active = true;
    }

    public void start() {
        if (this.active) {
            this.start = System.currentTimeMillis();
        }
    }

    public void start(boolean reset) {
        if (reset) {
            this.reset();
        }
        this.start();
    }

    public void stop() {
        if (this.active) {
            this.stop = System.currentTimeMillis();
            this.stats.add(this.stop - this.start);
        }
    }

    public void reset() {
        this.start = 0L;
        this.stop = 0L;
        this.stats.reset();
    }

    public long getTotalDuration() {
        return this.stats.getTotal();
    }

    public float getAverageDuration() {
        return this.stats.getAverage();
    }

    public int getSegmentCount() {
        return this.stats.getCount();
    }

    public String toString() {
        String units = MILLISECONDS;
        StringBuffer valueString = null;
        long value = this.getTotalDuration();
        if (value >= 1000L) {
            float fvalue = (float)value / 1000.0f;
            units = SECONDS;
            valueString = new StringBuffer(Float.toString(fvalue));
        } else {
            valueString = new StringBuffer(Long.toString(value));
        }
        valueString.append(units);
        return valueString.toString();
    }

    public String getTimeValueAsString(long value) {
        String units = MILLISECONDS;
        StringBuffer valueString = null;
        if (value >= 1000L) {
            float fvalue = (float)value / 1000.0f;
            units = SECONDS;
            valueString = new StringBuffer(Float.toString(fvalue));
        } else {
            valueString = new StringBuffer(Long.toString(value));
        }
        while (valueString.length() < 10) {
            valueString.insert(0, ' ');
        }
        return "" + valueString + units;
    }

    public String getTimeValueAsString(float value) {
        String units = MILLISECONDS;
        if (value >= 1000.0f) {
            value /= 1000.0f;
            units = SECONDS;
        }
        StringBuffer valueString = new StringBuffer(Float.toString(value));
        while (valueString.length() < 10) {
            valueString.insert(0, ' ');
        }
        return "" + valueString + units;
    }

    public String getValueAsString(int value) {
        StringBuffer valueString = new StringBuffer(Integer.toString(value));
        while (valueString.length() < 10) {
            valueString.insert(0, ' ');
        }
        return "" + valueString;
    }

    public void printStatistics(PrintStream stream) {
        if (this.active) {
            stream.println(CorePlugin.Util.getString("Stopwatch.Stopwatch_Statistics"));
            stream.println(CorePlugin.Util.getString("Stopwatch.Statistics_Total", this.getTimeValueAsString(this.stats.getTotal())));
            stream.println(CorePlugin.Util.getString("Stopwatch.Statistics_Previous", this.getTimeValueAsString(this.stats.getLast())));
            if (this.stats.getCount() > 1) {
                stream.println(CorePlugin.Util.getString("Stopwatch.Statistics_Count", this.getValueAsString(this.stats.getCount())));
                stream.println(CorePlugin.Util.getString("Stopwatch.Statistics_Average", this.getTimeValueAsString(this.stats.getAverage())));
                stream.println(CorePlugin.Util.getString("Stopwatch.Statistics_Minimum", this.getTimeValueAsString(this.stats.getMinimum())));
                stream.println(CorePlugin.Util.getString("Stopwatch.Statistics_Maximum", this.getTimeValueAsString(this.stats.getMaximum())));
            }
        }
    }

    public void printStatistics() {
        this.printStatistics(System.out);
    }

    public static void logTimedMessage(String context, String message, long time) {
        CorePlugin.Util.debug(context, Stopwatch.getTimeString(time) + message);
    }

    public static void logTimedMessage(String message, long time) {
        CorePlugin.Util.log(1, Stopwatch.getTimeString(time) + message);
    }

    public void stopLogIncrementAndRestart(String message) {
        this.stop();
        Stopwatch.logTimedMessage(message, this.getTotalDuration());
        this.start(true);
    }

    public void stopPrintIncrementAndRestart(String message) {
        this.stop();
        System.out.println(message + this.getTotalDuration());
        this.start(true);
    }

    private static String getTimeString(long time) {
        String timeString = "" + time;
        int nSpaces = 8 - timeString.length();
        StringBuffer buff = new StringBuffer();
        buff.append("Time = [");
        for (int i = 0; i < nSpaces; ++i) {
            buff.append(StringUtil.Constants.SPACE);
        }
        buff.append(timeString + "] ms : ");
        return buff.toString();
    }

    public class Statistics
    implements Serializable {
        private long minimum = 0L;
        private long maximum = 0L;
        private long last = 0L;
        private long total = 0L;
        private int count = 0;
        private boolean minimumInitialized = false;

        public long getMinimum() {
            return this.minimum;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public long getLast() {
            return this.last;
        }

        public float getAverage() {
            return (float)this.total / (float)this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public int getCount() {
            return this.count;
        }

        public void add(long duration) {
            ++this.count;
            this.total += duration;
            this.last = duration;
            if (duration > this.maximum) {
                this.maximum = duration;
            } else if (!this.minimumInitialized || duration < this.minimum) {
                this.minimum = duration;
                this.minimumInitialized = true;
            }
        }

        public void reset() {
            this.minimum = 0L;
            this.maximum = 0L;
            this.last = 0L;
            this.total = 0L;
            this.count = 0;
            this.minimumInitialized = false;
        }
    }
}

