/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.PortableContext;
import com.metamatrix.dqp.client.impl.PortableStringUtil;
import com.metamatrix.dqp.message.RequestID;

class RequestContext
implements PortableContext {
    private static final String HEADER = "RequestContext:";
    private RequestID requestID;
    private boolean update;

    RequestContext(RequestID id, boolean isUpdate) {
        this.requestID = id;
        this.update = isUpdate;
    }

    RequestContext(PortableContext context) throws MetaMatrixProcessingException {
        String[] parts = PortableStringUtil.getParts(context.getPortableString(), PortableStringUtil.PROP_SEPARATOR);
        if (parts == null || parts.length < 2 || parts.length > 3 || !parts[0].startsWith(HEADER)) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("RequestContext.invalid_context", context.getPortableString()));
        }
        parts[0] = parts[0].substring(HEADER.length());
        this.update = Boolean.valueOf(PortableStringUtil.getParts(parts[0], PortableStringUtil.EQUALS)[1]);
        long executionID = Long.parseLong(PortableStringUtil.getParts(parts[1], PortableStringUtil.EQUALS)[1]);
        String connectionID = null;
        if (parts.length == 3) {
            connectionID = PortableStringUtil.unescapeString(PortableStringUtil.getParts(parts[2], PortableStringUtil.EQUALS)[1]);
        }
        this.requestID = new RequestID(connectionID, executionID);
    }

    public String getPortableString() {
        StringBuffer buf = new StringBuffer(HEADER).append("update").append(PortableStringUtil.EQUALS).append(Boolean.toString(this.update)).append(PortableStringUtil.PROP_SEPARATOR).append("executionID").append(PortableStringUtil.EQUALS).append(Long.toString(this.requestID.getExecutionID()));
        if (this.requestID.getConnectionID() != null) {
            buf.append(PortableStringUtil.PROP_SEPARATOR).append("connectionID").append(PortableStringUtil.EQUALS).append(PortableStringUtil.escapeString(this.requestID.getConnectionID()));
        }
        return buf.toString();
    }

    RequestID getRequestID() {
        return this.requestID;
    }

    boolean isUpdate() {
        return this.update;
    }

    static RequestContext createRequestContextFromPortableContext(PortableContext context) throws MetaMatrixProcessingException {
        if (context == null) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("RequestContext.null_context"));
        }
        if (context instanceof RequestContext) {
            return (RequestContext)context;
        }
        return new RequestContext(context);
    }
}

