/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.transport;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.jdbc.transport.LocalTransportHandler;
import com.metamatrix.jdbc.transport.SocketTransportHandler;
import com.metamatrix.jdbc.transport.TransportHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MultiTransportFactory
implements ServerConnectionFactory {
    public static final String LOCAL_TRANSPORT = "Local";
    public static final String SOCKET_TRANSPORT = "Socket";
    private Map handlers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTransport(String transport) {
        Map map = this.handlers;
        synchronized (map) {
            TransportHandler handler = (TransportHandler)this.handlers.get(transport);
            if (handler != null) {
                handler.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConnection establishConnection(String transport, Properties connProps) throws ConnectionException, CommunicationException {
        TransportHandler handler = null;
        Map map = this.handlers;
        synchronized (map) {
            handler = (TransportHandler)this.handlers.get(transport);
            if (handler == null) {
                handler = this.createHandler(transport);
                this.handlers.put(transport, handler);
            }
        }
        return handler.createConnection(connProps);
    }

    public ServerConnection reestablishConnection(String contextPortableString, Properties connProps) throws CommunicationException {
        throw new UnsupportedOperationException();
    }

    private TransportHandler createHandler(String transport) {
        if (transport.equals(LOCAL_TRANSPORT)) {
            return new LocalTransportHandler();
        }
        if (transport.equals(SOCKET_TRANSPORT)) {
            return new SocketTransportHandler();
        }
        return null;
    }
}

