/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.transport;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactoryImpl;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactoryImpl;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import com.metamatrix.jdbc.transport.TransportHandler;
import java.util.Properties;

public class SocketTransportHandler
implements TransportHandler {
    protected ServerConnectionFactory factory = null;

    public synchronized ServerConnection createConnection(Properties props) throws ConnectionException, CommunicationException {
        this.initConnectionFactory();
        props.put("vdbName", props.getProperty("VirtualDatabaseName"));
        String vdbVersion = props.getProperty("VirtualDatabaseVersion");
        if (vdbVersion != null) {
            props.put("vdbVersion", vdbVersion);
        }
        boolean autoFailover = Boolean.valueOf(props.getProperty("autoFailover", Boolean.TRUE.toString()));
        SocketServerConnection actualConnection = (SocketServerConnection)this.factory.establishConnection(null, props);
        actualConnection.setAutoFailover(autoFailover);
        return actualConnection;
    }

    protected synchronized void initConnectionFactory() {
        if (this.factory == null) {
            ClientSideLogonFactoryImpl clientSideLogonFactory = ClientSideLogonFactoryImpl.getInstance();
            ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactory();
            ObjectSocketFactoryImpl objectSocketFactory = ObjectSocketFactoryImpl.getInstance();
            this.factory = new SocketServerConnectionFactory(SocketConstants.getMaxThreads(), SocketConstants.getTTL(), SocketConstants.getSynchronousTTL(), SocketConstants.getLog(this.getClass().getName()), this.getClass().getClassLoader(), SocketConstants.getInputBufferSize(), SocketConstants.getOutputBufferSize(), SocketConstants.getConserveBandwidth(), clientSideLogonFactory, serviceProxyFactory, objectSocketFactory);
        }
    }

    public synchronized void shutdown() {
        this.factory = null;
    }
}

