/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.platform.security.api.SessionToken;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class AuthorizationParameters
implements Serializable {
    private final String policyName;
    private final Collection addedUsers;
    private final Collection removedUsers;
    private final Collection addedPermissions;
    private final Collection removedPermissions;
    private final SessionToken token;

    public AuthorizationParameters(String policyName, Collection addedUsers, Collection removedUsers, Collection addedPermissions, Collection removedPermissions, SessionToken token) {
        ArgCheck.isNotNull(policyName);
        ArgCheck.isNotNull(token);
        this.policyName = policyName;
        this.addedUsers = addedUsers;
        this.removedUsers = removedUsers;
        this.addedPermissions = addedPermissions;
        this.removedPermissions = removedPermissions;
        this.token = token;
    }

    public AuthorizationParameters(String policyName, SessionToken token) {
        this(policyName, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, token);
    }

    public Collection getAddedUsers() {
        return this.addedUsers;
    }

    public Collection getRemovedUsers() {
        return this.removedUsers;
    }

    public Collection getAddedPermissions() {
        return this.addedPermissions;
    }

    public Collection getRemovedPermissions() {
        return this.removedPermissions;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getGrantor() {
        return this.token.getUsername();
    }

    public SessionToken getToken() {
        return this.token;
    }
}

