/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.function.FunctionMethods;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

final class XMLValueTranslator {
    private static String NEGATIVE_INFINITY = "-INF";
    private static String POSITIVE_INFINITY = "INF";
    private static String GMONTHDAY_FORMAT = "--MM-dd";
    private static String GYEAR_FORMAT = "0000";
    private static String GYEARMONTH_FORMAT = "yyyy-MM";
    private static String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static long YEAR_ZERO;
    private static String TIMESTAMP_MICROZEROS;
    public static final String DATETIME = "dateTime";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String GDAY = "gDay";
    public static final String GMONTH = "gMonth";
    public static final String GMONTHDAY = "gMonthDay";
    public static final String GYEAR = "gYear";
    public static final String GYEARMONTH = "gYearMonth";
    public static final String STRING = "string";
    private static final Map TYPE_CODE_MAP;
    private static final int DATETIME_CODE = 0;
    private static final int DOUBLE_CODE = 1;
    private static final int FLOAT_CODE = 2;
    private static final int GDAY_CODE = 3;
    private static final int GMONTH_CODE = 4;
    private static final int GMONTHDAY_CODE = 5;
    private static final int GYEAR_CODE = 6;
    private static final int GYEARMONTH_CODE = 7;

    XMLValueTranslator() {
    }

    static String translateToXMLValue(Object value, Class runtimeType, String builtInType) throws MetaMatrixComponentException {
        if (value == null) {
            return null;
        }
        Integer typeCode = (Integer)TYPE_CODE_MAP.get(builtInType);
        String valueStr = null;
        if (builtInType == null || typeCode == null || runtimeType == DataTypeManager.DefaultDataClasses.STRING || STRING.equals(builtInType)) {
            valueStr = XMLValueTranslator.defaultTranslation(value);
        } else {
            try {
                int type = typeCode;
                switch (type) {
                    case 0: {
                        valueStr = XMLValueTranslator.timestampToDateTime((Timestamp)value);
                        break;
                    }
                    case 1: {
                        valueStr = XMLValueTranslator.doubleToDouble((Double)value);
                        break;
                    }
                    case 2: {
                        valueStr = XMLValueTranslator.floatToFloat((Float)value);
                        break;
                    }
                    case 3: {
                        valueStr = XMLValueTranslator.bigIntegerTogDay((BigInteger)value);
                        break;
                    }
                    case 4: {
                        valueStr = XMLValueTranslator.bigIntegerTogMonth((BigInteger)value);
                        break;
                    }
                    case 5: {
                        valueStr = (String)FunctionMethods.formatTimestamp((Object)value, (Object)GMONTHDAY_FORMAT);
                        break;
                    }
                    case 6: {
                        valueStr = (String)FunctionMethods.formatBigInteger((Object)value, (Object)GYEAR_FORMAT);
                        break;
                    }
                    case 7: {
                        valueStr = XMLValueTranslator.timestampTogYearMonth(value);
                        break;
                    }
                    default: {
                        valueStr = XMLValueTranslator.defaultTranslation(value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LogManager.logWarning("XML_PLAN", (Throwable)e, new Object[]{"Conversion for builtInType " + builtInType + " and runtimeType " + runtimeType + " for value " + value + " of class " + value.getClass().toString() + " failed."});
                valueStr = XMLValueTranslator.defaultTranslation(value);
            }
        }
        if (valueStr != null && valueStr.length() == 0) {
            valueStr = null;
        }
        return valueStr;
    }

    private static String timestampTogYearMonth(Object value) throws FunctionExecutionException {
        Timestamp time = (Timestamp)value;
        String valueStr = (String)FunctionMethods.formatTimestamp((Object)value, (Object)GYEARMONTH_FORMAT);
        if (time.getTime() < YEAR_ZERO) {
            valueStr = "-" + valueStr;
        }
        return valueStr;
    }

    static String timestampToDateTime(Timestamp time) throws FunctionExecutionException {
        int i;
        String result = (String)FunctionMethods.formatTimestamp((Object)time, (Object)DATETIME_FORMAT);
        int nanos = time.getNanos();
        if (nanos == 0) {
            return result;
        }
        StringBuffer resultBuffer = new StringBuffer();
        boolean first = true;
        for (i = 0; i < 9 && nanos > 0; nanos /= 10, ++i) {
            int digit = nanos % 10;
            if (first) {
                if (digit <= 0) continue;
                resultBuffer.insert(0, digit);
                first = false;
                continue;
            }
            resultBuffer.insert(0, digit);
        }
        if (i < 9) {
            resultBuffer.insert(0, TIMESTAMP_MICROZEROS.substring(i));
        }
        resultBuffer.insert(0, ".");
        resultBuffer.insert(0, result);
        if (time.getTime() < YEAR_ZERO) {
            resultBuffer.insert(0, "-");
        }
        return resultBuffer.toString();
    }

    static String defaultTranslation(Object value) {
        return value.toString();
    }

    static String floatToFloat(Float f) {
        if (f.floatValue() == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (f.floatValue() == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        return XMLValueTranslator.defaultTranslation(f);
    }

    static String doubleToDouble(Double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        return XMLValueTranslator.defaultTranslation(d);
    }

    static String bigIntegerTogMonth(BigInteger value) {
        long month = value.longValue();
        if (month < 10L) {
            return "--0" + month;
        }
        return "--" + month;
    }

    static String bigIntegerTogDay(BigInteger value) {
        long day = value.longValue();
        if (day < 10L) {
            return "---0" + day;
        }
        return "---" + day;
    }

    static {
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i <= 14; ++i) {
            cal.set(i, 0);
        }
        YEAR_ZERO = cal.getTimeInMillis();
        TIMESTAMP_MICROZEROS = "000000000";
        TYPE_CODE_MAP = new HashMap(20);
        TYPE_CODE_MAP.put(DATETIME, new Integer(0));
        TYPE_CODE_MAP.put(DOUBLE, new Integer(1));
        TYPE_CODE_MAP.put(FLOAT, new Integer(2));
        TYPE_CODE_MAP.put(GDAY, new Integer(3));
        TYPE_CODE_MAP.put(GMONTH, new Integer(4));
        TYPE_CODE_MAP.put(GMONTHDAY, new Integer(5));
        TYPE_CODE_MAP.put(GYEAR, new Integer(6));
        TYPE_CODE_MAP.put(GYEARMONTH, new Integer(7));
    }
}

