/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class GroupCollectorVisitor
extends LanguageVisitor {
    private Collection groups;
    private boolean isIntoClauseGroup;
    private boolean ignoreInlineViewGroups = false;
    private Collection inlineViewGroups;

    public GroupCollectorVisitor(Collection groups) {
        if (groups == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0023"));
        }
        this.groups = groups;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public Collection getInlineViewGroups() {
        return this.inlineViewGroups;
    }

    public void setIgnoreInlineViewGroups(boolean ignoreInlineViewGroups) {
        this.ignoreInlineViewGroups = ignoreInlineViewGroups;
    }

    public void visit(GroupSymbol obj) {
        if (this.isIntoClauseGroup) {
            if (!obj.isTempGroupSymbol()) {
                this.groups.add(obj);
            }
            this.isIntoClauseGroup = false;
        } else {
            this.groups.add(obj);
        }
    }

    public void visit(StoredProcedure obj) {
        this.groups.add(obj.getGroup());
    }

    public void visit(Into obj) {
        this.isIntoClauseGroup = true;
    }

    public void visit(SubqueryFromClause obj) {
        if (this.ignoreInlineViewGroups) {
            if (this.inlineViewGroups == null) {
                this.inlineViewGroups = new ArrayList();
            }
            this.inlineViewGroups.add(obj.getGroupSymbol());
        }
    }

    public static void getGroups(LanguageObject obj, Collection groups) {
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static Collection getGroups(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection groups = null;
        groups = removeDuplicates ? new HashSet() : new ArrayList();
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        PreOrderNavigator.doVisit(obj, visitor);
        return groups;
    }

    public static void getGroupsIgnoreInlineViews(LanguageObject obj, Collection groups) {
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        visitor.setIgnoreInlineViewGroups(true);
        DeepPreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getInlineViewGroups() != null) {
            groups.removeAll(visitor.getInlineViewGroups());
        }
    }

    public static Collection getGroupsIgnoreInlineViews(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection groups = null;
        groups = removeDuplicates ? new HashSet() : new ArrayList();
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        visitor.setIgnoreInlineViewGroups(true);
        DeepPreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getInlineViewGroups() != null) {
            groups.removeAll(visitor.getInlineViewGroups());
        }
        return groups;
    }
}

