/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class VariableCollectorVisitor
extends LanguageVisitor {
    private Collection variables;

    public VariableCollectorVisitor(Collection variables) {
        if (variables == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0028"));
        }
        this.variables = variables;
    }

    public Collection getVariables() {
        return this.variables;
    }

    public void visit(ElementSymbol obj) {
        if (obj.isExternalReference()) {
            this.variables.add(obj);
        }
    }

    public static final void getVariables(LanguageObject obj, Collection variables) {
        VariableCollectorVisitor visitor = new VariableCollectorVisitor(variables);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final Collection getVariables(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection variables = null;
        variables = removeDuplicates ? new HashSet() : new ArrayList();
        VariableCollectorVisitor visitor = new VariableCollectorVisitor(variables);
        PreOrderNavigator.doVisit(obj, visitor);
        return variables;
    }
}

