/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class PluginVersionIdentifier {
    private int major = 0;
    private int minor = 0;
    private int service = 0;
    private String qualifier = "";
    private static final String SEPARATOR = ".";

    public PluginVersionIdentifier(int major, int minor, int service) {
        this(major, minor, service, null);
    }

    public PluginVersionIdentifier(int major, int minor, int service, String qualifier) {
        if (major < 0) {
            Assert.isTrue(false, NLS.bind(Messages.parse_postiveMajor, String.valueOf(major) + SEPARATOR + minor + SEPARATOR + service + SEPARATOR + qualifier));
        }
        if (minor < 0) {
            Assert.isTrue(false, NLS.bind(Messages.parse_postiveMinor, String.valueOf(major) + SEPARATOR + minor + SEPARATOR + service + SEPARATOR + qualifier));
        }
        if (service < 0) {
            Assert.isTrue(false, NLS.bind(Messages.parse_postiveService, String.valueOf(major) + SEPARATOR + minor + SEPARATOR + service + SEPARATOR + qualifier));
        }
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.service = service;
        this.qualifier = PluginVersionIdentifier.verifyQualifier(qualifier);
    }

    public PluginVersionIdentifier(String versionId) {
        Object[] parts = PluginVersionIdentifier.parseVersion(versionId);
        this.major = (Integer)parts[0];
        this.minor = (Integer)parts[1];
        this.service = (Integer)parts[2];
        this.qualifier = (String)parts[3];
    }

    public static IStatus validateVersion(String version) {
        try {
            PluginVersionIdentifier.parseVersion(version);
        }
        catch (RuntimeException e) {
            return new Status(4, "org.eclipse.core.runtime", 4, e.getMessage(), e);
        }
        return Status.OK_STATUS;
    }

    private static Object[] parseVersion(String versionId) {
        String s;
        if (versionId == null) {
            Assert.isNotNull(null, Messages.parse_emptyPluginVersion);
        }
        if ((s = versionId.trim()).equals("")) {
            Assert.isTrue(false, Messages.parse_emptyPluginVersion);
        }
        if (s.startsWith(SEPARATOR)) {
            Assert.isTrue(false, NLS.bind(Messages.parse_separatorStartVersion, s));
        }
        if (s.endsWith(SEPARATOR)) {
            Assert.isTrue(false, NLS.bind(Messages.parse_separatorEndVersion, s));
        }
        if (s.indexOf("..") != -1) {
            Assert.isTrue(false, NLS.bind(Messages.parse_doubleSeparatorVersion, s));
        }
        StringTokenizer st = new StringTokenizer(s, SEPARATOR);
        Vector<String> elements = new Vector<String>(4);
        while (st.hasMoreTokens()) {
            elements.addElement(st.nextToken());
        }
        int elementSize = elements.size();
        if (elementSize <= 0) {
            Assert.isTrue(false, NLS.bind(Messages.parse_oneElementPluginVersion, s));
        }
        if (elementSize > 4) {
            Assert.isTrue(false, NLS.bind(Messages.parse_fourElementPluginVersion, s));
        }
        int[] numbers = new int[3];
        try {
            numbers[0] = Integer.parseInt((String)elements.elementAt(0));
            if (numbers[0] < 0) {
                Assert.isTrue(false, NLS.bind(Messages.parse_postiveMajor, s));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Assert.isTrue(false, NLS.bind(Messages.parse_numericMajorComponent, s));
        }
        try {
            if (elementSize >= 2) {
                numbers[1] = Integer.parseInt((String)elements.elementAt(1));
                if (numbers[1] < 0) {
                    Assert.isTrue(false, NLS.bind(Messages.parse_postiveMinor, s));
                }
            } else {
                numbers[1] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Assert.isTrue(false, NLS.bind(Messages.parse_numericMinorComponent, s));
        }
        try {
            if (elementSize >= 3) {
                numbers[2] = Integer.parseInt((String)elements.elementAt(2));
                if (numbers[2] < 0) {
                    Assert.isTrue(false, NLS.bind(Messages.parse_postiveService, s));
                }
            } else {
                numbers[2] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Assert.isTrue(false, NLS.bind(Messages.parse_numericServiceComponent, s));
        }
        Object[] result = new Object[]{new Integer(numbers[0]), new Integer(numbers[1]), new Integer(numbers[2]), elementSize >= 4 ? PluginVersionIdentifier.verifyQualifier((String)elements.elementAt(3)) : ""};
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PluginVersionIdentifier)) {
            return false;
        }
        PluginVersionIdentifier v = (PluginVersionIdentifier)object;
        return v.getMajorComponent() == this.major && v.getMinorComponent() == this.minor && v.getServiceComponent() == this.service && v.getQualifierComponent().equals(this.qualifier);
    }

    public int hashCode() {
        int code = this.major + this.minor + this.service;
        if (this.qualifier.equals("")) {
            return code;
        }
        return code + this.qualifier.hashCode();
    }

    public int getMajorComponent() {
        return this.major;
    }

    public int getMinorComponent() {
        return this.minor;
    }

    public int getServiceComponent() {
        return this.service;
    }

    public String getQualifierComponent() {
        return this.qualifier;
    }

    public boolean isGreaterOrEqualTo(PluginVersionIdentifier id) {
        if (id == null) {
            return false;
        }
        if (this.major > id.getMajorComponent()) {
            return true;
        }
        if (this.major == id.getMajorComponent() && this.minor > id.getMinorComponent()) {
            return true;
        }
        if (this.major == id.getMajorComponent() && this.minor == id.getMinorComponent() && this.service > id.getServiceComponent()) {
            return true;
        }
        return this.major == id.getMajorComponent() && this.minor == id.getMinorComponent() && this.service == id.getServiceComponent() && this.qualifier.compareTo(id.getQualifierComponent()) >= 0;
    }

    public boolean isCompatibleWith(PluginVersionIdentifier id) {
        if (id == null) {
            return false;
        }
        if (this.major != id.getMajorComponent()) {
            return false;
        }
        if (this.minor > id.getMinorComponent()) {
            return true;
        }
        if (this.minor < id.getMinorComponent()) {
            return false;
        }
        if (this.service > id.getServiceComponent()) {
            return true;
        }
        if (this.service < id.getServiceComponent()) {
            return false;
        }
        return this.qualifier.compareTo(id.getQualifierComponent()) >= 0;
    }

    public boolean isEquivalentTo(PluginVersionIdentifier id) {
        if (id == null) {
            return false;
        }
        if (this.major != id.getMajorComponent()) {
            return false;
        }
        if (this.minor != id.getMinorComponent()) {
            return false;
        }
        if (this.service > id.getServiceComponent()) {
            return true;
        }
        if (this.service < id.getServiceComponent()) {
            return false;
        }
        return this.qualifier.compareTo(id.getQualifierComponent()) >= 0;
    }

    public boolean isPerfect(PluginVersionIdentifier id) {
        if (id == null) {
            return false;
        }
        return this.major == id.getMajorComponent() && this.minor == id.getMinorComponent() && this.service == id.getServiceComponent() && this.qualifier.equals(id.getQualifierComponent());
    }

    public boolean isGreaterThan(PluginVersionIdentifier id) {
        if (id == null) {
            return this.major != 0 || this.minor != 0 || this.service != 0 || !this.qualifier.equals("");
        }
        if (this.major > id.getMajorComponent()) {
            return true;
        }
        if (this.major < id.getMajorComponent()) {
            return false;
        }
        if (this.minor > id.getMinorComponent()) {
            return true;
        }
        if (this.minor < id.getMinorComponent()) {
            return false;
        }
        if (this.service > id.getServiceComponent()) {
            return true;
        }
        if (this.service < id.getServiceComponent()) {
            return false;
        }
        return this.qualifier.compareTo(id.getQualifierComponent()) > 0;
    }

    public String toString() {
        String base = String.valueOf(this.major) + SEPARATOR + this.minor + SEPARATOR + this.service;
        if (this.qualifier.equals("")) {
            return base;
        }
        return String.valueOf(base) + SEPARATOR + this.qualifier;
    }

    private static String verifyQualifier(String s) {
        char[] chars = s.trim().toCharArray();
        boolean whitespace = false;
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetterOrDigit(chars[i])) {
                chars[i] = 45;
                whitespace = true;
            }
            ++i;
        }
        return whitespace ? new String(chars) : s;
    }
}

