/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> allExports = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            ExportPackageDescription[] allDescriptions = this.framework.adaptor.getState().getExportedPackages();
            for (int i = 0; i < allDescriptions.length; ++i) {
                ExportedPackageImpl exportedPackage;
                if (!allDescriptions[i].isRoot() || (exportedPackage = this.createExportedPackage(allDescriptions[i])) == null || bundle != null && exportedPackage.supplier.getBundle() != bundle) continue;
                allExports.add(exportedPackage);
            }
        }
        return allExports.size() == 0 ? null : allExports.toArray(new ExportedPackage[allExports.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription description) {
        BundleDescription exporter = description.getExporter();
        if (exporter == null || exporter.getHost() != null) {
            return null;
        }
        BundleLoaderProxy proxy = (BundleLoaderProxy)exporter.getUserObject();
        if (proxy == null) {
            BundleHost bundle = (BundleHost)this.framework.getBundle(exporter.getBundleId());
            if (bundle == null) {
                return null;
            }
            proxy = bundle.getLoaderProxy();
        }
        return new ExportedPackageImpl(description, proxy);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ExportedPackage result = null;
        for (int i = 0; i < allExports.length; ++i) {
            if (!name.equals(allExports[i].getName())) continue;
            if (result == null) {
                result = allExports[i];
                continue;
            }
            Version curVersion = Version.parseVersion(result.getSpecificationVersion());
            Version newVersion = Version.parseVersion(allExports[i].getSpecificationVersion());
            if (newVersion.compareTo(curVersion) < 0) continue;
            result = allExports[i];
        }
        return result;
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>(1);
        for (int i = 0; i < allExports.length; ++i) {
            if (!name.equals(allExports[i].getName())) continue;
            result.add(allExports[i]);
        }
        return result.size() == 0 ? null : result.toArray(new ExportedPackage[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] input) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        AbstractBundle[] copy = null;
        if (input != null) {
            Bundle[] bundleArray = input;
            // MONITORENTER : input
            copy = new AbstractBundle[input.length];
            System.arraycopy(input, 0, copy, 0, input.length);
            // MONITOREXIT : bundleArray
        }
        final AbstractBundle[] bundles = copy;
        Thread refresh = this.framework.secureAction.createThread(new Runnable(){

            public void run() {
                PackageAdminImpl.this.doResolveBundles(bundles, true);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    public boolean resolveBundles(Bundle[] bundles) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundles == null) {
            bundles = this.framework.getAllBundles();
        }
        for (int i = 0; i < bundles.length; ++i) {
            if (((AbstractBundle)bundles[i]).isResolved()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doResolveBundles(AbstractBundle[] bundles, boolean refreshPackages) {
        try {
            this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
            AbstractBundle[] refreshedBundles = null;
            BundleDescription[] descriptions = null;
            BundleRepository bundleRepository = this.framework.bundles;
            synchronized (bundleRepository) {
                int numBundles;
                int n = numBundles = bundles == null ? 0 : bundles.length;
                if (!refreshPackages) {
                    descriptions = new BundleDescription[]{};
                } else if (numBundles > 0) {
                    ArrayList<BundleDescription> results = new ArrayList<BundleDescription>(numBundles);
                    for (int i = 0; i < numBundles; ++i) {
                        AbstractBundle[] sameNames;
                        BundleDescription description = bundles[i].getBundleDescription();
                        if (description != null && description.getBundleId() != 0L && !results.contains(description)) {
                            results.add(description);
                        }
                        if ((sameNames = this.framework.bundles.getBundles(bundles[i].getSymbolicName())) == null || sameNames.length <= 1) continue;
                        for (int j = 0; j < sameNames.length; ++j) {
                            BundleDescription sameName;
                            if (sameNames[j] == bundles[i] || (sameName = sameNames[j].getBundleDescription()) == null || sameName.getBundleId() == 0L || !sameName.isSingleton() || results.contains(sameName)) continue;
                            results.add(sameName);
                        }
                    }
                    descriptions = results.size() == 0 ? null : results.toArray(new BundleDescription[results.size()]);
                }
            }
            StateDelta stateDelta = this.framework.adaptor.getState().resolve(descriptions);
            refreshedBundles = this.processDelta(stateDelta.getChanges(), refreshPackages);
            if (refreshPackages) {
                AbstractBundle[] allBundles = this.framework.getAllBundles();
                for (int i = 0; i < allBundles.length; ++i) {
                    allBundles[i].unresolvePermissions(refreshedBundles);
                }
                this.resumeBundles(refreshedBundles);
            }
        }
        catch (Throwable t) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                Debug.printStackTrace(t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        finally {
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (refreshPackages) {
                this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            }
        }
    }

    private void resumeBundles(AbstractBundle[] bundles) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (bundles == null) {
            return;
        }
        for (int i = 0; i < bundles.length; ++i) {
            if (!bundles[i].isResolved()) continue;
            this.framework.resumeBundle(bundles[i]);
        }
    }

    private void suspendBundle(AbstractBundle bundle) throws BundleException {
        if (bundle.isActive() && !bundle.isFragment()) {
            boolean suspended = this.framework.suspendBundle(bundle, true);
            if (!suspended) {
                throw new BundleException(Msg.BUNDLE_STATE_CHANGE_EXCEPTION);
            }
        } else if (bundle.getStateChanging() != Thread.currentThread()) {
            bundle.beginStateChange();
        }
        if (Debug.DEBUG_PACKAGEADMIN && bundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + bundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundle = bundleDelta.getBundle();
            if (bundle.getDependents() != null && bundle.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundle);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            BundleLoaderProxy proxy = (BundleLoaderProxy)bundle.getUserObject();
            if (proxy != null) {
                BundleHost.closeBundleLoader(proxy);
                try {
                    proxy.getBundleHost().getBundleData().close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle bundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (bundle == null) {
            BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            return null;
        }
        boolean resolve = true;
        if (bundle.isFragment()) {
            BundleDescription[] hosts = bundleDescription.getHost().getHosts();
            for (int i = 0; i < hosts.length; ++i) {
                BundleHost host = (BundleHost)this.framework.getBundle(hosts[i].getBundleId());
                resolve = ((BundleFragment)bundle).addHost(host.getLoaderProxy());
            }
        }
        if (resolve) {
            bundle.resolve();
        }
        return bundle;
    }

    private AbstractBundle[] applyDeltas(BundleDelta[] bundleDeltas) throws BundleException {
        ArrayList<AbstractBundle> results = new ArrayList<AbstractBundle>(bundleDeltas.length);
        for (int i = 0; i < bundleDeltas.length; ++i) {
            AbstractBundle bundle;
            int type = bundleDeltas[i].getType();
            if ((type & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltas[i]);
            }
            if ((type & 8) == 0 || (bundle = this.setResolved(bundleDeltas[i].getBundle())) == null || !bundle.isResolved()) continue;
            results.add(bundle);
        }
        return results.size() == 0 ? null : results.toArray(new AbstractBundle[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBundle[] processDelta(BundleDelta[] bundleDeltas, boolean refreshPackages) {
        Util.sort(bundleDeltas, 0, bundleDeltas.length);
        ArrayList<AbstractBundle> bundlesList = new ArrayList<AbstractBundle>(bundleDeltas.length);
        for (int i = 0; i < bundleDeltas.length; ++i) {
            AbstractBundle changedBundle = this.framework.getBundle(bundleDeltas[i].getBundle().getBundleId());
            if (changedBundle == null) continue;
            bundlesList.add(changedBundle);
        }
        AbstractBundle[] refresh = bundlesList.toArray(new AbstractBundle[bundlesList.size()]);
        boolean[] previouslyResolved = new boolean[refresh.length];
        AbstractBundle[] resolved = null;
        try {
            try {
                int i;
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                }
                boolean restart = false;
                for (i = refresh.length - 1; i >= 0; --i) {
                    previouslyResolved[i] = refresh[i].isResolved();
                    if (refresh[i] == this.framework.systemBundle) {
                        restart = true;
                        continue;
                    }
                    if ((refresh[i].bundledata.getType() & 2) != 0 && previouslyResolved[i]) {
                        restart = true;
                        continue;
                    }
                    if ((refresh[i].bundledata.getType() & 4) == 0) continue;
                    restart = true;
                }
                if (restart) {
                    if (refreshPackages) {
                        this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                    }
                    this.restartFramework();
                }
                if (refreshPackages) {
                    for (i = refresh.length - 1; i >= 0; --i) {
                        this.suspendBundle(refresh[i]);
                    }
                }
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: refresh the bundles");
                }
                BundleRepository i2 = this.framework.bundles;
                synchronized (i2) {
                    for (int i3 = 0; i3 < refresh.length; ++i3) {
                        refresh[i3].refresh();
                    }
                }
                for (int i4 = 0; i4 < refresh.length; ++i4) {
                    if (!previouslyResolved[i4]) continue;
                    this.framework.publishBundleEvent(64, refresh[i4]);
                }
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: applying deltas to bundles");
                }
                BundleRepository i4 = this.framework.bundles;
                synchronized (i4) {
                    resolved = this.applyDeltas(bundleDeltas);
                }
            }
            finally {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: release the state change locks");
                }
                if (refreshPackages) {
                    for (int i = 0; i < refresh.length; ++i) {
                        AbstractBundle changedBundle = refresh[i];
                        changedBundle.completeStateChange();
                    }
                }
            }
            if (refreshPackages) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException e) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + e.getMessage());
                        Debug.printStackTrace(e);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, e));
                }
            }
        }
        catch (BundleException e) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e.getMessage());
                Debug.printStackTrace(e.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, e));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        if (resolved != null) {
            for (int i = 0; i < resolved.length; ++i) {
                this.framework.publishBundleEvent(32, (Bundle)resolved[i]);
            }
        }
        return refresh;
    }

    private void restartFramework() {
        System.getProperties().put("osgi.forcedRestart", "true");
        this.framework.shutdown();
        System.exit(23);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        AbstractBundle[] bundles = symbolicName == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null || bundles.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> result = new ArrayList<BundleLoaderProxy>(bundles.length);
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].isFragment() || !bundles[i].isResolved() || bundles[i].getSymbolicName() == null) continue;
            result.add(((BundleHost)bundles[i]).getLoaderProxy());
        }
        return result.size() == 0 ? null : result.toArray(new RequiredBundle[result.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] bundles = this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null) {
            return null;
        }
        if (versionRange == null) {
            Bundle[] result = new AbstractBundle[bundles.length];
            System.arraycopy(bundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>(bundles.length);
        VersionRange range = new VersionRange(versionRange);
        for (int i = 0; i < bundles.length; ++i) {
            if (!range.isIncluded(bundles[i].getVersion())) continue;
            result.add(bundles[i]);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AbstractBundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleLoaderProxy[] hosts = ((AbstractBundle)bundle).getHosts();
        if (hosts == null) {
            return null;
        }
        Bundle[] result = new Bundle[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            result[i] = hosts[i].getBundleHost();
        }
        return result;
    }

    Bundle getBundlePriv(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleLoader)((BundleClassLoader)((Object)cl)).getDelegate()).bundle;
        }
        if (cl == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PackageAdminImpl.this.getBundlePriv(clazz);
            }
        });
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(SystemBundle systemBundle) {
        this.checkSystemBundle(systemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        for (int i = 0; i < descriptions.length; ++i) {
            long bundleId = descriptions[i].getBundleId();
            if (bundleId == 0L) continue;
            this.setResolved(descriptions[i]);
        }
    }

    private void checkSystemBundle(SystemBundle systemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription newSystemBundle = state.getFactory().createBundleDescription(state, systemBundle.getHeaders(""), systemBundle.getLocation(), 0L);
            if (newSystemBundle == null) {
                throw new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            BundleDescription oldSystemBundle = state.getBundle(0L);
            if (oldSystemBundle != null) {
                ExportPackageDescription[] newPackages;
                ExportPackageDescription[] oldPackages;
                boolean different = false;
                if (newSystemBundle.getVersion() != null && !newSystemBundle.getVersion().equals(oldSystemBundle.getVersion())) {
                    different = true;
                }
                if ((oldPackages = oldSystemBundle.getExportPackages()).length >= (newPackages = newSystemBundle.getExportPackages()).length) {
                    for (int i = 0; i < newPackages.length; ++i) {
                        if (oldPackages[i].getName().equals(newPackages[i].getName())) {
                            Version oldVersion = oldPackages[i].getVersion();
                            Version newVersion = newPackages[i].getVersion();
                            if (oldVersion == null) {
                                if (newVersion == null) continue;
                                different = true;
                            } else {
                                if (((Object)oldVersion).equals(newVersion)) continue;
                                different = true;
                            }
                        } else {
                            different = true;
                        }
                        break;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    state.removeBundle(0L);
                    state.addBundle(newSystemBundle);
                    state.resolve(false);
                }
            } else {
                state.addBundle(newSystemBundle);
                state.resolve(false);
            }
            ExportPackageDescription[] packages = newSystemBundle.getExportPackages();
            if (packages != null) {
                String[] systemPackages = new String[packages.length];
                for (int i = 0; i < packages.length; ++i) {
                    String version;
                    ExportPackageDescription spec = packages[i];
                    if (spec.getName().equals("org.osgi.framework") && (version = spec.getVersion().toString()) != null) {
                        System.getProperties().put("org.osgi.framework.version", version);
                    }
                    systemPackages[i] = spec.getName();
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, e.getMessage()));
        }
    }
}

