/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.resolver;

import org.osgi.framework.Version;

public class VersionRange {
    private static final Version versionMax = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final VersionRange emptyRange = new VersionRange(null);
    private Version minVersion;
    private boolean includeMin;
    private Version maxVersion;
    private boolean includeMax;

    public VersionRange(Version minVersion, boolean includeMin, Version maxVersion, boolean includeMax) {
        this.minVersion = minVersion;
        this.includeMin = includeMin;
        this.maxVersion = maxVersion;
        this.includeMax = includeMax;
    }

    public VersionRange(String versionRange) {
        if (versionRange == null || versionRange.length() == 0) {
            this.minVersion = Version.emptyVersion;
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
            return;
        }
        if ((versionRange = versionRange.trim()).charAt(0) == '[' || versionRange.charAt(0) == '(') {
            int comma = versionRange.indexOf(44);
            if (comma < 0) {
                throw new IllegalArgumentException();
            }
            char last = versionRange.charAt(versionRange.length() - 1);
            if (last != ']' && last != ')') {
                throw new IllegalArgumentException();
            }
            this.minVersion = Version.parseVersion(versionRange.substring(1, comma).trim());
            this.includeMin = versionRange.charAt(0) == '[';
            this.maxVersion = Version.parseVersion(versionRange.substring(comma + 1, versionRange.length() - 1).trim());
            this.includeMax = last == ']';
        } else {
            this.minVersion = Version.parseVersion(versionRange.trim());
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
        }
    }

    public Version getMinimum() {
        return this.minVersion;
    }

    public boolean getIncludeMinimum() {
        return this.includeMin;
    }

    public Version getMaximum() {
        return this.maxVersion;
    }

    public boolean getIncludeMaximum() {
        return this.includeMax;
    }

    public boolean isIncluded(Version version) {
        Version minRequired = this.getMinimum();
        if (minRequired == null) {
            return true;
        }
        if (version == null) {
            return false;
        }
        Version maxRequired = this.getMaximum() == null ? versionMax : this.getMaximum();
        int minCheck = this.includeMin ? 0 : 1;
        int maxCheck = this.includeMax ? 0 : -1;
        return version.compareTo(minRequired) >= minCheck && version.compareTo(maxRequired) <= maxCheck;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange vr = (VersionRange)object;
        if (this.minVersion != null && vr.getMinimum() != null) {
            if (!this.minVersion.equals(vr.getMinimum())) return false;
            if (this.includeMin != vr.includeMin) return false;
            if (this.maxVersion != null && vr.getMaximum() != null) {
                if (!this.maxVersion.equals(vr.getMaximum())) return false;
                if (this.includeMax != vr.includeMax) return false;
                return true;
            }
            if (this.maxVersion != vr.getMaximum()) return false;
            return true;
        }
        if (this.minVersion != vr.getMinimum()) return false;
        return true;
    }

    public String toString() {
        if (this.minVersion == null) {
            return Version.emptyVersion.toString();
        }
        if (versionMax.equals(this.maxVersion)) {
            return this.minVersion.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append(this.includeMin ? (char)'[' : '(');
        result.append(this.minVersion);
        result.append(',');
        result.append(this.maxVersion);
        result.append(this.includeMax ? (char)']' : ')');
        return result.toString();
    }
}

