/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.gemini.util;

import com.metamatrix.api.core.message.DefaultMessage;
import com.metamatrix.api.core.xmi.EntityInfo;
import com.metamatrix.api.core.xmi.FeatureInfo;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.gemini.GeminiPlugin;
import com.metamatrix.gemini.metadata.io.xmi.GeminiXmiReaderAdapter;
import com.metamatrix.gemini.util.MetamodelMapper;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.transformation.InputBinding;
import com.metamatrix.metamodels.transformation.InputParameter;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.MappingClassObject;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.MappingClassSetContainer;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.xml.ChoiceErrorMode;
import com.metamatrix.metamodels.xml.ChoiceOption;
import com.metamatrix.metamodels.xml.SoapEncoding;
import com.metamatrix.metamodels.xml.ValueType;
import com.metamatrix.metamodels.xml.XmlAll;
import com.metamatrix.metamodels.xml.XmlAttribute;
import com.metamatrix.metamodels.xml.XmlChoice;
import com.metamatrix.metamodels.xml.XmlComment;
import com.metamatrix.metamodels.xml.XmlCommentHolder;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlElementHolder;
import com.metamatrix.metamodels.xml.XmlEntityHolder;
import com.metamatrix.metamodels.xml.XmlNamespace;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xml.XmlSequence;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;

public class XmlMetamodelMapper
extends MetamodelMapper {
    private final XmlDocumentFactory xmlFactory = XmlDocumentFactory.eINSTANCE;
    private final TransformationFactory transFactory = TransformationFactory.eINSTANCE;
    private final MappingFactory mappingFactory = MappingFactory.eINSTANCE;
    private final Collection choiceMappers = new ArrayList();
    private MappingClassSetContainer mappingClassCntr;
    private TransformationContainer transformationCntr;
    private XmlDocument currentDocument;
    private InputBinding currentBinding;
    private HashMap treeMappingObjects = new HashMap();
    private HashMap treeMappings = new HashMap();

    public XmlMetamodelMapper(GeminiXmiReaderAdapter ra) {
        super(ra);
        this.initialize();
    }

    public void postProcess() {
        for (ChoiceOptionMapper next : this.choiceMappers) {
            next.process(this.ra, this);
        }
    }

    public EObject createEObject(EntityInfo info, Object parent) {
        ArgCheck.isNotNull((Object)info);
        String eclass = info.getMetaClassName();
        ObjectID guid = this.createObjectID(info.getUUID());
        String name = info.getName();
        if (ModelerCore.DEBUG_GEMINI) {
            System.out.println("Create Entity : " + eclass);
        }
        XmlRoot newChild = null;
        if (eclass.equals("Model")) {
            ModelAnnotation ma = this.ra.getContents().getModelAnnotation();
            if (ma == null) {
                ma = this.coreFactory.createModelAnnotation();
            }
            ma.setDescription(name);
            ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/XmlDocument");
            this.ra.setPrimaryUri("http://www.metamatrix.com/metamodels/XmlDocument");
            ma.setModelType(ModelType.VIRTUAL_LITERAL);
            newChild = ma;
        } else if (eclass.equals("Element")) {
            if (parent instanceof XmlDocument) {
                XmlRoot root = this.xmlFactory.createXmlRoot();
                root.setName(name);
                ((XmlDocument)parent).setRoot(root);
                newChild = root;
            } else if (parent instanceof XmlElementHolder) {
                XmlElement element = this.xmlFactory.createXmlElement();
                element.setName(name);
                element.setParent((XmlEntityHolder)parent);
                newChild = element;
            }
        } else if (eclass.equals("Document")) {
            XmlDocument doc = this.xmlFactory.createXmlDocument();
            doc.setName(info.getName());
            this.currentDocument = doc;
            newChild = doc;
        } else if (eclass.equals("All")) {
            XmlAll all = this.xmlFactory.createXmlAll();
            if (parent instanceof XmlEntityHolder) {
                all.setParent((XmlEntityHolder)parent);
            }
            newChild = all;
        } else if (eclass.equals("Choice")) {
            XmlChoice choice = this.xmlFactory.createXmlChoice();
            if (parent instanceof XmlEntityHolder) {
                choice.setParent((XmlEntityHolder)parent);
            }
            newChild = choice;
        } else if (eclass.equals("Sequence")) {
            XmlSequence seq = this.xmlFactory.createXmlSequence();
            if (parent instanceof XmlEntityHolder) {
                seq.setParent((XmlEntityHolder)parent);
            }
            newChild = seq;
        } else if (eclass.equals("Attribute")) {
            XmlAttribute att = this.xmlFactory.createXmlAttribute();
            att.setName(name);
            if (parent instanceof XmlElement) {
                att.setElement((XmlElement)parent);
            }
            newChild = att;
        } else if (eclass.equals("Comment")) {
            XmlComment comment = this.xmlFactory.createXmlComment();
            if (parent instanceof XmlCommentHolder) {
                comment.setParent((XmlCommentHolder)parent);
            }
            newChild = comment;
        } else if (eclass.equals("Namespace")) {
            XmlNamespace ns = this.xmlFactory.createXmlNamespace();
            if (parent instanceof XmlElement) {
                ns.setElement((XmlElement)parent);
            }
            newChild = ns;
        } else if (eclass.equals("MappingClasses")) {
            MappingClassSet mcs = this.transFactory.createMappingClassSet();
            mcs.setTarget((EObject)this.currentDocument);
            MappingClassSetContainer mc = this.findMappingClassSetContainer();
            mc.getMappingClassSets().add((Object)mcs);
            newChild = mcs;
        } else if (eclass.equals("MappingClass")) {
            MappingClass mc = null;
            if (parent instanceof MappingClassSet) {
                mc = this.transFactory.createMappingClass();
                mc.setName(name);
                mc.setMappingClassSet((MappingClassSet)parent);
                this.treeMappingObjects.put(mc, info.getUUID());
                TreeMappingRoot root = this.transFactory.createTreeMappingRoot();
                root.setTarget((EObject)this.currentDocument);
                root.getInputs().add((Object)mc);
                this.findTransformationContainer().getTransformationMappings().add((Object)root);
                this.treeMappings.put(info.getUUID(), root);
                newChild = mc;
            } else if (parent instanceof SqlTransformation) {
                InputSet is = this.transFactory.createInputSet();
                MappingClass parentMC = this.findParentMappingClass(info);
                if (parentMC == null) {
                    String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Unable_to_find_parent_MappingClass_for_InputSet_{0}_1");
                    this.messages.add((Object)new DefaultMessage(msg, 3));
                } else {
                    is.setMappingClass(parentMC);
                    ObjectID id = parentMC.getObjectId();
                    this.treeMappingObjects.put(is, id.toString());
                }
                newChild = is;
            }
        } else if (eclass.equals("MappingAttribute")) {
            if (parent instanceof MappingClass) {
                MappingClassColumn mcc = this.transFactory.createMappingClassColumn();
                mcc.setName(name);
                mcc.setMappingClass((MappingClass)parent);
                this.treeMappingObjects.put(mcc, info.getUUID());
                Object key = this.treeMappingObjects.get(parent);
                TreeMappingRoot parentMapping = (TreeMappingRoot)this.treeMappings.get(key);
                if (parentMapping != null) {
                    Mapping mapping = this.mappingFactory.createMapping();
                    mapping.setNestedIn((Mapping)parentMapping);
                    mapping.getInputs().add((Object)mcc);
                    this.treeMappings.put(info.getUUID(), mapping);
                } else {
                    String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Unable_to_resolve_parent_transformation_mapping_for_{0}_1", (Object)info.getName());
                    this.messages.add((Object)new DefaultMessage(msg, 3));
                }
                newChild = mcc;
            } else if (parent instanceof InputSet) {
                InputParameter ip = this.transFactory.createInputParameter();
                ip.setInputSet((InputSet)parent);
                ip.setName(name);
                this.currentBinding = this.transFactory.createInputBinding();
                this.currentBinding.setInputParameter(ip);
                boolean done = false;
                EObject temp = (EObject)parent;
                while (temp != null && !done) {
                    if (temp instanceof MappingClassSet) {
                        this.currentBinding.setMappingClassSet((MappingClassSet)temp);
                        done = true;
                        continue;
                    }
                    temp = temp.eContainer();
                }
                this.treeMappingObjects.put(ip, info.getUUID());
                Object key = this.treeMappingObjects.get(parent);
                TreeMappingRoot parentMapping = (TreeMappingRoot)this.treeMappings.get(key);
                if (parentMapping != null) {
                    Mapping mapping = MappingFactory.eINSTANCE.createMapping();
                    mapping.setNestedIn((Mapping)parentMapping);
                    mapping.getInputs().add((Object)ip);
                    this.treeMappings.put(info.getUUID(), mapping);
                } else {
                    String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Unable_to_resolve_parent_transformation_mapping_for_{0}_1", (Object)info.getName());
                    this.messages.add((Object)new DefaultMessage(msg, 3));
                }
                newChild = ip;
            }
        } else if (eclass.equals("TemporaryTable")) {
            StagingTable st = this.transFactory.createStagingTable();
            st.setName(name);
            if (parent instanceof MappingClassSet) {
                st.setMappingClassSet((MappingClassSet)parent);
            } else if (parent instanceof InputSet) {
                st.setInputSet((InputSet)parent);
            }
            this.treeMappingObjects.put(st, info.getUUID());
            TreeMappingRoot root = this.transFactory.createTreeMappingRoot();
            root.setTarget((EObject)this.currentDocument);
            root.getInputs().add((Object)st);
            this.findTransformationContainer().getTransformationMappings().add((Object)root);
            this.treeMappings.put(info.getUUID(), root);
            newChild = st;
        } else if (eclass.equals("TemporaryColumn")) {
            MappingClassColumn col = this.transFactory.createMappingClassColumn();
            col.setName(name);
            col.setMappingClass((MappingClass)((StagingTable)parent));
            this.treeMappingObjects.put(col, info.getUUID());
            Object key = this.treeMappingObjects.get(parent);
            TreeMappingRoot parentMapping = (TreeMappingRoot)this.treeMappings.get(key);
            if (parentMapping != null) {
                Mapping mapping = this.mappingFactory.createMapping();
                mapping.setNestedIn((Mapping)parentMapping);
                mapping.getInputs().add((Object)col);
                this.treeMappings.put(info.getUUID(), mapping);
            } else {
                String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Unable_to_resolve_parent_transformation_mapping_for_{0}_1", (Object)info.getName());
                this.messages.add((Object)new DefaultMessage(msg, 3));
            }
            newChild = col;
        } else {
            String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Could_not_find_xml_eclass_for_{0}_1", (Object)eclass);
            this.messages.add((Object)new DefaultMessage(msg, 3));
        }
        if (newChild != null) {
            newChild.setObjectId(guid);
        }
        if (newChild != null && parent != null && newChild.eContainer() == null && !(newChild instanceof XmlDocument) && !eclass.equals("Model")) {
            this.addUnableToAddChildMessage((EObject)newChild, (EObject)parent, info);
        }
        if (ModelerCore.DEBUG_GEMINI) {
            System.out.println("DONE Create Entity : " + eclass);
        }
        return newChild;
    }

    protected void processCustomFeature(Integer sfID, EObject eObject, FeatureInfo info) {
        ArgCheck.isNotNull((Object)sfID);
        if (info.getValue() == null) {
            return;
        }
        String value = info.getValue().toString();
        String featureName = info.getMetaClassName() + "." + info.getName();
        if (sfID == 10) {
            ChoiceErrorMode cem = value.equals("true") ? ChoiceErrorMode.THROW_LITERAL : ChoiceErrorMode.DISCARD_LITERAL;
            ((XmlChoice)eObject).setDefaultErrorMode(cem);
        } else if (featureName.endsWith(".criteria") && eObject instanceof ChoiceOption) {
            this.choiceMappers.add(new ChoiceOptionMapper((ChoiceOption)eObject, value));
        } else if (featureName.equals("MappingClass.recursive")) {
            if (eObject instanceof MappingClass) {
                ((MappingClass)eObject).setRecursive(Boolean.valueOf(value).booleanValue());
            } else if (eObject instanceof InputSet) {
                // empty if block
            }
        } else if (featureName.equals("Choice.choiceDefaultObject")) {
            if (eObject instanceof XmlChoice) {
                ObjectID id = this.createObjectID(value);
                GeminiXmiReaderAdapter geminiXmiReaderAdapter = this.ra;
                geminiXmiReaderAdapter.getClass();
                GeminiXmiReaderAdapter.ReferenceHolder rh = new GeminiXmiReaderAdapter.ReferenceHolder(geminiXmiReaderAdapter, eObject, id, eObject.eClass().getEStructuralFeature(sfID.intValue()));
                this.ra.addUnresolvedReference(rh);
            }
        } else if (sfID == 1 && eObject instanceof MappingClass) {
            MappingClassSet mcs = ((MappingClass)eObject).getMappingClassSet();
            ObjectID id = this.createObjectID(value);
            GeminiXmiReaderAdapter geminiXmiReaderAdapter = this.ra;
            geminiXmiReaderAdapter.getClass();
            GeminiXmiReaderAdapter.ReferenceHolder rh = new GeminiXmiReaderAdapter.ReferenceHolder(geminiXmiReaderAdapter, (EObject)mcs, id, mcs.eClass().getEStructuralFeature(sfID.intValue()));
            this.ra.addUnresolvedReference(rh);
        } else if (sfID == 2) {
            if (eObject instanceof MappingClassColumn || eObject instanceof InputParameter) {
                ObjectID id = this.createObjectID(value);
                GeminiXmiReaderAdapter geminiXmiReaderAdapter = this.ra;
                geminiXmiReaderAdapter.getClass();
                GeminiXmiReaderAdapter.ReferenceHolder rh = new GeminiXmiReaderAdapter.ReferenceHolder(geminiXmiReaderAdapter, eObject, id, eObject.eClass().getEStructuralFeature(sfID.intValue()));
                this.ra.addUnresolvedReference(rh);
            }
        } else if (sfID == 0) {
            if (eObject instanceof MappingClass) {
                ((MappingClass)eObject).setName(value);
            } else if (eObject instanceof InputSet) {
                // empty if block
            }
        } else if (sfID == 7 && eObject instanceof XmlAttribute) {
            ((XmlAttribute)eObject).setValue(value);
            if (info.getName().equals("defaultValue")) {
                ValueType vt = ValueType.DEFAULT_LITERAL;
                ((XmlAttribute)eObject).setValueType(vt);
            }
        } else if (sfID == 8 && eObject instanceof XmlAttribute) {
            if (value.equals("false")) {
                ValueType vt = ValueType.FIXED_LITERAL;
                ((XmlAttribute)eObject).setValueType(vt);
            }
        } else if (sfID == 4) {
            Object key = this.treeMappingObjects.get(eObject);
            EObject root = (EObject)this.treeMappings.get(key);
            if (root instanceof Mapping) {
                GeminiXmiReaderAdapter.ReferenceHolder rh;
                ObjectID id;
                if (value != null && value.indexOf(",") == -1) {
                    id = this.createObjectID(value);
                    GeminiXmiReaderAdapter geminiXmiReaderAdapter = this.ra;
                    geminiXmiReaderAdapter.getClass();
                    GeminiXmiReaderAdapter.ReferenceHolder rh2 = new GeminiXmiReaderAdapter.ReferenceHolder(geminiXmiReaderAdapter, root, id, root.eClass().getEStructuralFeature(sfID.intValue()));
                    this.ra.addUnresolvedReference(rh2);
                } else if (value != null) {
                    StringTokenizer tokenizer = new StringTokenizer(value, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String next = tokenizer.nextToken();
                        ObjectID id2 = this.createObjectID(next);
                        GeminiXmiReaderAdapter geminiXmiReaderAdapter = this.ra;
                        geminiXmiReaderAdapter.getClass();
                        rh = new GeminiXmiReaderAdapter.ReferenceHolder(geminiXmiReaderAdapter, root, id2, root.eClass().getEStructuralFeature(sfID.intValue()));
                        this.ra.addUnresolvedReference(rh);
                    }
                }
                if (eObject instanceof InputParameter) {
                    if (this.currentBinding != null) {
                        id = this.createObjectID(value);
                        MappingClassColumn mcc = (MappingClassColumn)this.ra.getEObjectById(id);
                        if (mcc != null) {
                            this.currentBinding.setMappingClassColumn(mcc);
                        } else {
                            EStructuralFeature sf = this.currentBinding.eClass().getEStructuralFeature(2);
                            GeminiXmiReaderAdapter geminiXmiReaderAdapter = this.ra;
                            geminiXmiReaderAdapter.getClass();
                            rh = new GeminiXmiReaderAdapter.ReferenceHolder(geminiXmiReaderAdapter, (EObject)this.currentBinding, id, sf);
                            this.ra.addUnresolvedReference(rh);
                        }
                    } else {
                        String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.No_existing_MappingBinding_for_setting_MappingClass_Column_reference_1");
                        this.messages.add((Object)new DefaultMessage(msg, 3));
                    }
                }
            } else if (root != null) {
                String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Unexpected_parent_for_TransformationMapping_outputs____2");
                this.messages.add((Object)new DefaultMessage(msg, 3));
            }
        } else if (featureName.equals("Document.soapEncoding")) {
            SoapEncoding val = SoapEncoding.get((String)value.toUpperCase());
            ((XmlDocument)eObject).setSoapEncoding(val);
        } else {
            String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.Couldn__t_process_custom_feature_{0}_1", (Object)info.getName());
            this.messages.add((Object)new DefaultMessage(msg, 3));
        }
    }

    private MappingClass findParentMappingClass(EntityInfo info) {
        if (info == null) {
            return null;
        }
        FeatureInfo ownerFeatureInfo = info.getOwnerFeatureInfo();
        if (ownerFeatureInfo == null) {
            return null;
        }
        EntityInfo parentInfo = ownerFeatureInfo.getOwnerEntityInfo();
        if (parentInfo == null) {
            return null;
        }
        ObjectID uuid = this.createObjectID(parentInfo.getUUID());
        EObject parent = this.ra.getEObjectById(uuid);
        if (parent instanceof MappingClass) {
            return (MappingClass)parent;
        }
        return this.findParentMappingClass(parentInfo);
    }

    private MappingClassSetContainer findMappingClassSetContainer() {
        if (this.mappingClassCntr != null) {
            return this.mappingClassCntr;
        }
        for (Object content : this.ra.getTargetResource().getContents()) {
            if (!(content instanceof MappingClassSetContainer)) continue;
            this.mappingClassCntr = (MappingClassSetContainer)content;
            return this.mappingClassCntr;
        }
        this.mappingClassCntr = this.transFactory.createMappingClassSetContainer();
        this.ra.getTargetResource().getContents().add((Object)this.mappingClassCntr);
        return this.mappingClassCntr;
    }

    private TransformationContainer findTransformationContainer() {
        if (this.transformationCntr != null) {
            return this.transformationCntr;
        }
        for (Object content : this.ra.getTargetResource().getContents()) {
            if (!(content instanceof TransformationContainer)) continue;
            this.transformationCntr = (TransformationContainer)content;
            return this.transformationCntr;
        }
        this.transformationCntr = this.transFactory.createTransformationContainer();
        this.ra.getTargetResource().getContents().add((Object)this.transformationCntr);
        return this.transformationCntr;
    }

    private void initialize() {
        this.featureNameMap.put("All.excludeFromDocument", new Integer(6));
        this.featureNameMap.put("Attribute.excludeFromDocument", new Integer(2));
        this.featureNameMap.put("Attribute.name", new Integer(1));
        this.featureNameMap.put("Attribute.namespace", new Integer(6));
        this.featureNameMap.put("Choice.excludeFromDocument", new Integer(6));
        this.featureNameMap.put("Comment.text", new Integer(0));
        this.featureNameMap.put("Document.charEncoding", new Integer(4));
        this.featureNameMap.put("Document.formatted", new Integer(5));
        this.featureNameMap.put("Document.name", new Integer(2));
        this.featureNameMap.put("Document.processingInstructions", new Integer(1));
        this.featureNameMap.put("Document.version", new Integer(6));
        this.featureNameMap.put("Element.excludeFromDocument", new Integer(2));
        this.featureNameMap.put("Element.name", new Integer(1));
        this.featureNameMap.put("Element.namespace", new Integer(6));
        this.featureNameMap.put("Element.processingInstructions", new Integer(12));
        this.featureNameMap.put("Element.recursive", new Integer(16));
        this.featureNameMap.put("MappingAttribute.name", new Integer(0));
        this.featureNameMap.put("Namespace.namespacePrefix", new Integer(0));
        this.featureNameMap.put("Namespace.namespaceURI", new Integer(1));
        this.featureNameMap.put("Sequence.excludeFromDocument", new Integer(6));
        this.refFeatureNameMap.put("All.schemaObjectReference", new Integer(9));
        this.refFeatureNameMap.put("Attribute.schemaObjectReference", new Integer(5));
        this.refFeatureNameMap.put("Choice.schemaObjectReference", new Integer(9));
        this.refFeatureNameMap.put("Element.schemaObjectReference", new Integer(5));
        this.refFeatureNameMap.put("Sequence.schemaObjectReference", new Integer(9));
        this.ignoredFeatures.add("All.contents");
        this.ignoredFeatures.add("All.name");
        this.ignoredFeatures.add("All.recursive");
        this.ignoredFeatures.add("Attribute.changeability");
        this.ignoredFeatures.add("Attribute.constraint");
        this.ignoredFeatures.add("Attribute.contents");
        this.ignoredFeatures.add("Attribute.constraintValue");
        this.ignoredFeatures.add("Attribute.isAutoIncremented");
        this.ignoredFeatures.add("Attribute.isCaseSensitive");
        this.ignoredFeatures.add("Attribute.isCurrency");
        this.ignoredFeatures.add("Attribute.isLengthFixed");
        this.ignoredFeatures.add("Attribute.isNullable");
        this.ignoredFeatures.add("Attribute.isSigned");
        this.ignoredFeatures.add("Attribute.multiplicity");
        this.ignoredFeatures.add("Attribute.mapping");
        this.ignoredFeatures.add("Attribute.searchType");
        this.ignoredFeatures.add("Attribute.supportsSelect");
        this.ignoredFeatures.add("Attribute.supportsSet");
        this.ignoredFeatures.add("Attribute.supportsSubscription");
        this.ignoredFeatures.add("Attribute.supportsUpdate");
        this.ignoredFeatures.add("Choice.contents");
        this.ignoredFeatures.add("Choice.name");
        this.ignoredFeatures.add("Choice.recursive");
        this.ignoredFeatures.add("Document.contents");
        this.ignoredFeatures.add("Document.schemaObjectReference");
        this.ignoredFeatures.add("Element.contents");
        this.ignoredFeatures.add("Element.mapping");
        this.ignoredFeatures.add("MappingAttribute.changeability");
        this.ignoredFeatures.add("MappingAttribute.isAutoIncremented");
        this.ignoredFeatures.add("MappingAttribute.isCaseSensitive");
        this.ignoredFeatures.add("MappingAttribute.isCurrency");
        this.ignoredFeatures.add("MappingAttribute.isLengthFixed");
        this.ignoredFeatures.add("MappingAttribute.isNullable");
        this.ignoredFeatures.add("MappingAttribute.isSigned");
        this.ignoredFeatures.add("MappingAttribute.multiplicity");
        this.ignoredFeatures.add("MappingAttribute.searchType");
        this.ignoredFeatures.add("MappingAttribute.supportsSelect");
        this.ignoredFeatures.add("MappingAttribute.supportsSet");
        this.ignoredFeatures.add("MappingAttribute.supportsSubscription");
        this.ignoredFeatures.add("MappingAttribute.supportsUpdate");
        this.ignoredFeatures.add("MappingClass.contents");
        this.ignoredFeatures.add("MappingClasses.contents");
        this.ignoredFeatures.add("MappingClasses.mappingDefinition");
        this.ignoredFeatures.add("MappingClasses.name");
        this.ignoredFeatures.add("Model.contents");
        this.ignoredFeatures.add("Model.name");
        this.ignoredFeatures.add("Namespace.name");
        this.ignoredFeatures.add("Sequence.contents");
        this.ignoredFeatures.add("Sequence.name");
        this.ignoredFeatures.add("Sequence.recursive");
        this.customFeatureMap.put("All.criteria", new Integer(1));
        this.customFeatureMap.put("Attribute.changeability", new Integer(8));
        this.customFeatureMap.put("Attribute.defaultValue", new Integer(7));
        this.customFeatureMap.put("Attribute.initialValue", new Integer(7));
        this.customFeatureMap.put("Attribute.mapping", new Integer(4));
        this.customFeatureMap.put("Choice.criteria", new Integer(1));
        this.customFeatureMap.put("Choice.criteriaDefaultError", new Integer(10));
        this.customFeatureMap.put("Choice.choiceDefaultObject", new Integer(11));
        this.customFeatureMap.put("Document.soapEncoding", new Integer(8));
        this.customFeatureMap.put("Element.criteria", new Integer(7));
        this.customFeatureMap.put("MappingClass.documentReference", new Integer(4));
        this.customFeatureMap.put("MappingClass.name", new Integer(0));
        this.customFeatureMap.put("MappingClass.recursive", new Integer(1));
        this.customFeatureMap.put("MappingAttribute.documentReference", new Integer(4));
        this.customFeatureMap.put("MappingAttribute.type", new Integer(2));
        this.customFeatureMap.put("Sequence.criteria", new Integer(1));
        this.customFeatureMap.put("TemporaryTable.documentReference", new Integer(4));
        this.customFeatureMap.put("TemporaryColumn.type", new Integer(2));
    }

    private class ChoiceOptionMapper {
        public static final String EMPTY_STRING = "";
        private final ChoiceOption option;
        private final String criteria;

        public ChoiceOptionMapper(ChoiceOption option, String criteria) {
            this.option = option;
            this.criteria = criteria;
        }

        private String getRuntimeFullName(Object theObject) {
            String result = EMPTY_STRING;
            if (theObject instanceof MappingClassColumn || theObject instanceof MappingClass) {
                result = TransformationHelper.getSqlEObjectFullName((EObject)((MappingClassObject)theObject));
            }
            return result;
        }

        public void process(GeminiXmiReaderAdapter ra, MetamodelMapper mapper) {
            block9: {
                if (this.criteria == null) {
                    return;
                }
                try {
                    int uuidIndex = this.criteria.indexOf("mmuuid");
                    if (uuidIndex == -1) {
                        this.option.setChoiceCriteria(this.criteria);
                    } else {
                        StringBuffer realCriteria = new StringBuffer(this.criteria.substring(0, this.criteria.indexOf("mmuuid")));
                        String workingCriteria = this.criteria.substring(this.criteria.indexOf("mmuuid"));
                        while (uuidIndex != -1) {
                            uuidIndex = workingCriteria.indexOf("mmuuid");
                            realCriteria.append(workingCriteria.substring(0, uuidIndex));
                            String uuid = workingCriteria.substring(uuidIndex, uuidIndex + 43);
                            ObjectID id = mapper.createObjectID(uuid);
                            EObject eObject = ra.getEObjectById(id);
                            if (eObject == null) {
                                realCriteria.append(uuid);
                            } else {
                                String fullName = this.getRuntimeFullName(eObject);
                                realCriteria.append(fullName);
                            }
                            workingCriteria = workingCriteria.substring(uuidIndex + 43);
                            uuidIndex = workingCriteria.indexOf("mmuuid");
                            if (uuidIndex == -1) {
                                realCriteria.append(workingCriteria);
                                continue;
                            }
                            realCriteria.append(workingCriteria.substring(0, uuidIndex));
                            workingCriteria = workingCriteria.substring(uuidIndex);
                        }
                        this.option.setChoiceCriteria(realCriteria.toString());
                    }
                }
                catch (Exception err) {
                    String msg = GeminiPlugin.Util.getString("XmlMetamodelMapper.0", (Object)this.criteria);
                    XmlMetamodelMapper.this.messages.add((Object)new DefaultMessage(msg, 3));
                    if (this.option == null) break block9;
                    this.option.setChoiceCriteria(this.criteria);
                }
            }
        }
    }
}

