/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.client.resources;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;

public interface Images
    extends
    ClientBundle {

    public Images INSTANCE = GWT.create(Images.class);

    @Source("images/package.gif")
    ImageResource packageImage();

    @Source("images/rule_asset.gif")
    ImageResource ruleAsset();

    @Source("images/deploy.gif")
    ImageResource deploy();

    @Source("images/rules.gif")
    ImageResource rules();

    @Source("images/analyze.gif")
    ImageResource analyze();

    @Source("images/find.gif")
    ImageResource find();

    @Source("images/inbox.gif")
    ImageResource inbox();

    @Source("images/category_small.gif")
    ImageResource categorySmall();

    @Source("images/status_small.gif")
    ImageResource statusSmall();

    @Source("images/chart_organisation.gif")
    ImageResource chartOrganisation();

    @Source("images/spreadsheet_small.gif")
    ImageResource spreadsheetSmall();

    @Source("images/gdst.gif")
    ImageResource gdst();

    @Source("images/test_manager.gif")
    ImageResource testManager();

    @Source("images/package.gif")
    ImageResource packages();

    @Source("images/empty_package.gif")
    ImageResource emptyPackage();

    @Source("images/dsl.gif")
    ImageResource dsl();

    @Source("images/enumeration.gif")
    ImageResource enumeration();

    @Source("images/workingset.gif")
    ImageResource workingset();

    @Source("images/new_file_small.png")
    ImageResource newFile();

    @Source("images/new_file_large.png")
    ImageResource newFileLarge();

    @Source("images/technical_rule_assets.gif")
    ImageResource technicalRuleAssets();

    @Source("images/new_package.gif")
    ImageResource newPackage();

    @Source("images/function_assets.gif")
    ImageResource functionAssets();

    @Source("images/model_asset.gif")
    ImageResource modelAsset();

    @Source("images/business_rule.gif")
    ImageResource businessRule();

    @Source("images/ruleflow_small.gif")
    ImageResource ruleflowSmall();

    @Source("images/new_enumeration.gif")
    ImageResource newEnumeration();

    @Source("images/refresh.gif")
    ImageResource refresh();

    @Source("images/new_template.gif")
    ImageResource newTemplate();

    @Source("images/snapshot_small.gif")
    ImageResource snapshotSmall();

    @Source("images/tag.png")
    ImageResource tag();

    @Source("images/backup_small.gif")
    ImageResource backupSmall();

    @Source("images/error.gif")
    ImageResource error();

    @Source("images/icoUsers_small.gif")
    ImageResource icoUsersSmall();

    @Source("images/icoUsers.gif")
    ImageResource icoUsers();

    @Source("images/save_edit.gif")
    ImageResource saveEdit();

    @Source("images/rule_verification.png")
    ImageResource ruleVerification();

    @Source("images/information.gif")
    ImageResource information();

    @Source("images/config.png")
    ImageResource config();

    @Source("images/close.gif")
    ImageResource close();

    @Source("images/scrollleft.gif")
    ImageResource scrollLeft();

    @Source("images/scrollright.gif")
    ImageResource scrollRight();

    @Source("images/backup_large.png")
    ImageResource backupLarge();

    @Source("images/edit_category.gif")
    ImageResource editCategory();

    @Source("images/snapshot.png")
    ImageResource snapshot();

    @Source("images/managment.gif")
    ImageResource management();

    @Source("images/new_item.gif")
    ImageResource newItem();
    
    @Source("images/new_item_disabled.gif")
    ImageResource newItemDisabled();
    
    @Source("images/delete_item_small.gif")
    ImageResource deleteItemSmall();

    @Source("images/status_large.png")
    ImageResource statusLarge();

    @Source("images/desc.gif")
    ImageResource desc();

    @Source("images/decision_table.png")
    ImageResource decisionTable();

    @Source("images/validation_error.gif")
    ImageResource validationError();

    @Source("images/attention_needed.png")
    ImageResource attentionNeeded();

    @Source("images/edit.gif")
    ImageResource edit();

    @Source("images/editDisabled.gif")
    ImageResource editDisabled();

    @Source("images/clock.png")
    ImageResource clock();

    @Source("images/collapse.gif")
    ImageResource collapse();

    @Source("images/collapseall.gif")
    ImageResource collapseAll();

    @Source("images/expand.gif")
    ImageResource expand();

    @Source("images/expandall.gif")
    ImageResource expandAll();
    
    @Source("images/newex_wiz.gif")
    ImageResource newexWiz();

    @Source("images/add_field_to_fact.gif")
    ImageResource addFieldToFact();

    @Source("images/add_connective.gif")
    ImageResource addConnective();

    @Source("images/new_item_below.png")
    ImageResource newItemBelow();

    @Source("images/shuffle_down.gif")
    ImageResource shuffleDown();

    @Source("images/shuffle_up.gif")
    ImageResource shuffleUp();

    @Source("images/warning.gif")
    ImageResource warning();

    @Source("images/model_large.png")
    ImageResource modelLarge();

    @Source("images/upload.gif")
    ImageResource upload();

    @Source("images/package_large.png")
    ImageResource packageLarge();

    @Source("images/new_wiz.gif")
    ImageResource newWiz();

    @Source("images/red_anime.gif")
    ImageResource redAnime();

    @Source("images/view_source.gif")
    ImageResource viewSource();

    @Source("images/trash.gif")
    ImageResource trash();
    
    @Source("images/trash_disabled.gif")
    ImageResource trashDisabled();

    @Source("images/home_icon.gif")
    ImageResource homeIcon();

    @Source("images/execution_trace.gif")
    ImageResource executionTrace();

    @Source("images/searching.gif")
    ImageResource searching();

    @Source("images/test_passed.png")
    ImageResource testPassed();

    @Source("images/analyse_large.png")
    ImageResource analyzeLarge();

    @Source("images/scenario_large.png")
    ImageResource scenarioLarge();

    @Source("images/note.gif")
    ImageResource note();

    @Source("images/feed.png")
    ImageResource feed();

    @Source("images/spinner.gif")
    ImageResource spinner();

    @Source("images/new_dsl_pattern.gif")
    ImageResource newDSLPattern();

    @Source("images/new_dsl_action.gif")
    ImageResource newDSLAction();

    @Source("images/class.gif")
    ImageResource classImage();

    @Source("images/field.gif")
    ImageResource field();

    @Source("images/meta_data.png")
    ImageResource metadata();

    @Source("images/asset_version.png")
    ImageResource assetVersion();

    @Source("images/ruleflow_large.png")
    ImageResource ruleflowLarge();

    @Source("images/package_builder.png")
    ImageResource packageBuilder();

    @Source("images/tick_green.gif")
    ImageResource greenTick();

    @Source("images/warning-large.png")
    ImageResource warningLarge();

    @Source("images/system_search.png")
    ImageResource systemSearch();

    @Source("images/login.gif")
    ImageResource login();

    @Source("images/fact_template.gif")
    ImageResource factTemplate();

    @Source("images/fact.gif")
    ImageResource fact();
    
    @Source("images/event_log_small.png")
    ImageResource eventLogSmall();

    @Source("images/event_log_large.png")
    ImageResource eventLogLarge();

    @Source("images/user_permissions_small.png")
    ImageResource userPermissionsSmall();

    @Source("images/user_permissions_large.png")
    ImageResource userPermissionsLarge();
    
    @Source("images/flatView.gif")
    ImageResource flatView();

    @Source("images/hierarchicalView.gif")
    ImageResource hierarchicalView();

    @Source("images/tick.png")
    ImageResource tick();

    @Source("images/mandatory.png")
    ImageResource mandatory();
    
    @Source("images/info-large.png")
    ImageResource infoLarge();

    @Source("images/transparentIco.png")
    ImageResource transparentIco();
}