/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttachedObjectListHolder<T>
implements PartialStateHolder {
    private boolean initialState;
    private List<T> attachedObjects = new ArrayList(2);

    AttachedObjectListHolder() {
    }

    public void markInitialState() {
        if (!this.attachedObjects.isEmpty()) {
            for (Object t : this.attachedObjects) {
                if (!(t instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)t).markInitialState();
            }
        }
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        if (!this.attachedObjects.isEmpty()) {
            for (Object t : this.attachedObjects) {
                if (!(t instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)t).clearInitialState();
            }
        }
        this.initialState = false;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.attachedObjects == null) {
            return null;
        }
        if (this.initialState) {
            Object[] attachedObjects = new Object[this.attachedObjects.size()];
            boolean stateWritten = false;
            int len = attachedObjects.length;
            for (int i = 0; i < len; ++i) {
                Object attachedObject = this.attachedObjects.get(i);
                if (!(attachedObject instanceof StateHolder)) continue;
                StateHolder sh = (StateHolder)attachedObject;
                if (!sh.isTransient()) {
                    attachedObjects[i] = sh.saveState(context);
                }
                if (attachedObjects[i] == null) continue;
                stateWritten = true;
            }
            return stateWritten ? attachedObjects : null;
        }
        Object[] attachedObjects = new Object[this.attachedObjects.size()];
        int len = attachedObjects.length;
        for (int i = 0; i < len; ++i) {
            attachedObjects[i] = UIComponentBase.saveAttachedState((FacesContext)context, this.attachedObjects.get(i));
        }
        return attachedObjects;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] attachedObjects = (Object[])state;
        if (attachedObjects.length > 0 && attachedObjects[0] instanceof StateHolderSaver) {
            if (this.attachedObjects != null) {
                this.attachedObjects.clear();
            } else {
                this.attachedObjects = new ArrayList(2);
            }
            int len = attachedObjects.length;
            for (int i = 0; i < len; ++i) {
                Object restored = ((StateHolderSaver)attachedObjects[i]).restore(context);
                if (restored == null) continue;
                this.attachedObjects.add(restored);
            }
        } else {
            int len = attachedObjects.length;
            for (int i = 0; i < len; ++i) {
                Object l = this.attachedObjects.get(i);
                if (!(l instanceof StateHolder)) continue;
                ((StateHolder)l).restoreState(context, attachedObjects[i]);
            }
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }

    void add(T attachedObject) {
        this.clearInitialState();
        this.attachedObjects.add(attachedObject);
    }

    void remove(T attachedObject) {
        this.clearInitialState();
        this.attachedObjects.remove(attachedObject);
    }

    T[] asArray(Class<T> type) {
        return new ArrayList(this.attachedObjects).toArray((Object[])Array.newInstance(type, this.attachedObjects.size()));
    }
}

